/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSource;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.UserDataProvider;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.panels.ResultSetPanel;
import org.syncope.console.rest.UserRestClient;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.syncope.console.wicket.extensions.markup.html.repeater.data.table.UserAttrColumn;

public class ResultSetPanel
extends Panel
implements IEventSource {
    private static final long serialVersionUID = -9170191461250434024L;
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetPanel.class);
    private static final int EDIT_MODAL_WIN_HEIGHT = 550;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    private static final int DISPLAYATTRS_MODAL_WIN_HEIGHT = 550;
    private static final int DISPLAYATTRS_MODAL_WIN_WIDTH = 550;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private PreferenceManager preferences;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    private int rows;
    protected final WebMarkupContainer container;
    private final FeedbackPanel feedbackPanel;
    private boolean filtered;
    private NodeCond filter;
    private AjaxFallbackDefaultDataTable<UserTO> resultTable;
    private UserDataProvider dataProvider;
    private final ModalWindow editmodal = new ModalWindow("editModal");
    private final BasePage page;

    public <T extends AbstractAttributableTO> ResultSetPanel(String id, boolean filtered, NodeCond searchCond, PageReference callerRef) {
        super(id);
        this.setOutputMarkupId(true);
        this.page = (BasePage)callerRef.getPage();
        this.filtered = filtered;
        this.filter = searchCond;
        this.feedbackPanel = this.page.getFeedbackPanel();
        this.editmodal.setCssClassName("w_silver");
        this.editmodal.setInitialHeight(550);
        this.editmodal.setInitialWidth(800);
        this.editmodal.setCookieName("edit-modal");
        this.add(new Component[]{this.editmodal});
        ModalWindow displaymodal = new ModalWindow("displayModal");
        displaymodal.setCssClassName("w_silver");
        displaymodal.setInitialHeight(550);
        displaymodal.setInitialWidth(550);
        displaymodal.setCookieName("display-modal");
        this.add(new Component[]{displaymodal});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.updateResultTable(false);
        1 displayAttrsLink = new /* Unavailable Anonymous Inner Class!! */;
        displayAttrsLink.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        MetaDataRoleAuthorizationStrategy.authorize((Component)displayAttrsLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "changeView"));
        this.container.add(new Component[]{displayAttrsLink});
        Form paginatorForm = new Form("paginator");
        this.container.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rows"), this.preferences.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.setWindowClosedReloadCallback(this.editmodal);
        this.setWindowClosedReloadCallback(displaymodal);
    }

    public void search(NodeCond searchCond, AjaxRequestTarget target) {
        this.filter = searchCond;
        this.dataProvider.setSearchCond(this.filter);
        target.add(new Component[]{this.container});
    }

    private void updateResultTable(boolean create) {
        this.rows = this.preferences.getPaginatorRows(this.getRequest(), "users.paginator.rows");
        this.dataProvider = new UserDataProvider(this.userRestClient, this.rows, this.filtered);
        this.dataProvider.setSearchCond(this.filter);
        int currentPage = this.resultTable != null ? (create ? this.resultTable.getPageCount() - 1 : this.resultTable.getCurrentPage()) : 0;
        this.resultTable = new AjaxFallbackDefaultDataTable("resultTable", this.getColumns(), (ISortableDataProvider)this.dataProvider, this.rows);
        this.resultTable.setCurrentPage(currentPage);
        this.resultTable.setOutputMarkupId(true);
        this.container.addOrReplace(new Component[]{this.resultTable});
    }

    private List<IColumn<UserTO>> getColumns() {
        ArrayList<IColumn<UserTO>> columns = new ArrayList<IColumn<UserTO>>();
        for (String name : this.preferences.getList(this.getRequest(), "users.details.view")) {
            Field field = null;
            try {
                field = UserTO.class.getDeclaredField(name);
            }
            catch (Exception ue) {
                LOG.debug("Error retrieving UserTO field {}", (Object)name, (Object)ue);
                try {
                    field = AbstractAttributableTO.class.getDeclaredField(name);
                }
                catch (Exception aae) {
                    LOG.error("Error retrieving AbstractAttributableTO field {}", (Object)name, (Object)aae);
                }
            }
            if ("token".equalsIgnoreCase(name)) {
                columns.add((IColumn<UserTO>)new TokenColumn("token"));
                continue;
            }
            if (field != null && field.getType().equals(Date.class)) {
                columns.add((IColumn<UserTO>)new DatePropertyColumn((IModel)new ResourceModel(name, name), name, name));
                continue;
            }
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel(name, name), name, name));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.schema));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.derived.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.derivedSchema));
        }
        for (String name : this.preferences.getList(this.getRequest(), "users.virtual.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn(name, UserAttrColumn.SchemaType.virtualSchema));
        }
        if (columns.isEmpty()) {
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("id", "id"), "id", "id"));
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("username", "username"), "username", "username"));
            columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new ResourceModel("status", "status"), "status", "status"));
        }
        columns.add((IColumn<UserTO>)new /* Unavailable Anonymous Inner Class!! */);
        columns.add((IColumn<UserTO>)new /* Unavailable Anonymous Inner Class!! */);
        return columns;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof EventDataWrapper) {
            EventDataWrapper data = (EventDataWrapper)event.getPayload();
            AjaxRequestTarget target = data.getTarget();
            this.updateResultTable(data.isCreate());
            target.add(new Component[]{this.container});
        }
    }

    private void setWindowClosedReloadCallback(ModalWindow window) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ BasePage access$000(ResultSetPanel x0) {
        return x0.page;
    }

    static /* synthetic */ AjaxFallbackDefaultDataTable access$100(ResultSetPanel x0) {
        return x0.resultTable;
    }

    static /* synthetic */ int access$200(ResultSetPanel x0) {
        return x0.rows;
    }

    static /* synthetic */ PreferenceManager access$300(ResultSetPanel x0) {
        return x0.preferences;
    }

    static /* synthetic */ ModalWindow access$400(ResultSetPanel x0) {
        return x0.editmodal;
    }

    static /* synthetic */ UserRestClient access$500(ResultSetPanel x0) {
        return x0.userRestClient;
    }

    static /* synthetic */ FeedbackPanel access$600(ResultSetPanel x0) {
        return x0.feedbackPanel;
    }
}

