/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.RoleTO;
import org.syncope.console.pages.panels.RoleSummaryPanel;
import org.syncope.console.pages.panels.RoleTabPanel;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.wicket.markup.html.tree.TreeActionLinkPanel;

public class RoleSummaryPanel
extends Panel {
    private static final long serialVersionUID = 643769814985593156L;
    @SpringBean
    private RoleRestClient restClient;
    private RoleTO selectedNode;
    private Fragment fragment;
    private RoleTabPanel roleTabPanel;
    private TreeActionLinkPanel actionLink;
    private PageReference callerPageRef;
    private ModalWindow window;

    public RoleSummaryPanel(String id, ModalWindow window, PageReference callerPageRef) {
        super(id);
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.fragment = new Fragment("rolePanel", this.selectedNode == null ? "fakerootFrag" : (this.selectedNode.getId() != 0L ? "roleViewPanel" : "rootPanel"), (MarkupContainer)this);
        if (this.selectedNode != null) {
            if (this.selectedNode.getId() != 0L) {
                this.roleTabPanel = new RoleTabPanel("nodeViewPanel", this.selectedNode, window, callerPageRef);
                this.roleTabPanel.setOutputMarkupId(true);
                this.fragment.add(new Component[]{this.roleTabPanel});
            } else {
                this.actionLink = new TreeActionLinkPanel("actionLink", this.selectedNode.getId(), (IModel)new CompoundPropertyModel((Object)this.selectedNode), window, callerPageRef);
                this.fragment.add(new Component[]{this.actionLink});
            }
        }
        this.add(new Component[]{this.fragment});
    }

    public RoleTO getSelectedNode() {
        return this.selectedNode;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof TreeNodeClickUpdate) {
            TreeNodeClickUpdate update = (TreeNodeClickUpdate)event.getPayload();
            this.selectedNode = this.restClient.readRole(update.getSelectedNodeId());
            this.fragment = new Fragment("rolePanel", update.getSelectedNodeId() != 0L ? "roleViewPanel" : "rootPanel", (MarkupContainer)this);
            if (update.getSelectedNodeId() != 0L) {
                this.roleTabPanel = new RoleTabPanel("nodeViewPanel", this.selectedNode, this.window, this.callerPageRef);
                this.roleTabPanel.setOutputMarkupId(true);
                this.fragment.addOrReplace(new Component[]{this.roleTabPanel});
            } else {
                this.actionLink = new TreeActionLinkPanel("actionLink", update.getSelectedNodeId().longValue(), (IModel)new CompoundPropertyModel((Object)this.selectedNode), this.window, this.callerPageRef);
                this.actionLink.setOutputMarkupId(true);
                this.fragment.addOrReplace(new Component[]{this.actionLink});
            }
            this.replace((Component)this.fragment);
            update.getTarget().add(new Component[]{this});
        }
    }
}

