/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.search.ResourceCond;
import org.syncope.client.search.SyncopeUserCond;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.SearchCondWrapper;
import org.syncope.console.pages.panels.UserSearchPanel;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;

public class UserSearchPanel
extends Panel {
    private static final long serialVersionUID = -1769527800450203738L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSearchPanel.class);
    private List<String> ATTRIBUTES_NOTINCLUDED = Arrays.asList("attributes", "derivedAttributes", "virtualAttributes", "serialVersionUID", "memberships", "resources", "password", "propagationStatusMap");
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    private final IModel<List<String>> dnames = new /* Unavailable Anonymous Inner Class!! */;
    private final IModel<List<String>> unames = new /* Unavailable Anonymous Inner Class!! */;
    private final IModel<List<String>> ronames = new /* Unavailable Anonymous Inner Class!! */;
    private final IModel<List<String>> renames = new /* Unavailable Anonymous Inner Class!! */;
    private final IModel<List<AttributeCond.Type>> attributeTypes = new /* Unavailable Anonymous Inner Class!! */;
    private final IModel<List<SearchCondWrapper.FilterType>> filterTypes = new /* Unavailable Anonymous Inner Class!! */;
    final FeedbackPanel searchFeedback;
    final List<SearchCondWrapper> searchConditionList;

    public UserSearchPanel(String id) {
        this(id, null);
    }

    public UserSearchPanel(String id, NodeCond searchCondition) {
        super(id);
        this.setOutputMarkupId(true);
        WebMarkupContainer searchFormContainer = new WebMarkupContainer("searchFormContainer");
        searchFormContainer.setOutputMarkupId(true);
        this.searchFeedback = new FeedbackPanel("searchFeedback", (IFeedbackMessageFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.searchFeedback.setOutputMarkupId(true);
        this.add(new Component[]{this.searchFeedback});
        if (searchCondition == null) {
            this.searchConditionList = new ArrayList();
            this.searchConditionList.add(new SearchCondWrapper());
        } else {
            this.searchConditionList = this.getSearchCondWrappers(searchCondition);
        }
        searchFormContainer.add(new Component[]{new SearchView(this, "searchView", this.searchConditionList, searchFormContainer)});
        8 addAndButton = new /* Unavailable Anonymous Inner Class!! */;
        addAndButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addAndButton});
        9 addOrButton = new /* Unavailable Anonymous Inner Class!! */;
        addOrButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addOrButton});
        this.add(new Component[]{searchFormContainer});
    }

    public FeedbackPanel getSearchFeedback() {
        return this.searchFeedback;
    }

    private List<SearchCondWrapper> getSearchCondWrappers(NodeCond searchCond) {
        LOG.debug("Search condition: {}", (Object)searchCond);
        ArrayList<SearchCondWrapper> wrappers = new ArrayList<SearchCondWrapper>();
        switch (10.$SwitchMap$org$syncope$client$search$NodeCond$Type[searchCond.getType().ordinal()]) {
            case 1: 
            case 2: {
                wrappers.add(this.getSearchCondWrapper(searchCond));
                break;
            }
            case 3: 
            case 4: {
                wrappers.add(this.getSearchCondWrapper(searchCond.getLeftNodeCond()));
                SearchCondWrapper wrapper = this.getSearchCondWrapper(searchCond.getRightNodeCond());
                wrapper.setOperationType(searchCond.getType() == NodeCond.Type.AND ? SearchCondWrapper.OperationType.AND : SearchCondWrapper.OperationType.OR);
                wrappers.add(wrapper);
                break;
            }
        }
        LOG.debug("Search condition wrappers: {}", wrappers);
        return wrappers;
    }

    private SearchCondWrapper getSearchCondWrapper(NodeCond searchCond) {
        SearchCondWrapper wrapper = new SearchCondWrapper();
        if (searchCond.getSyncopeUserCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.ATTRIBUTE);
            wrapper.setFilterName(searchCond.getSyncopeUserCond().getSchema());
            wrapper.setType(searchCond.getSyncopeUserCond().getType());
            wrapper.setFilterValue(searchCond.getSyncopeUserCond().getExpression());
        }
        if (searchCond.getAttributeCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.ATTRIBUTE);
            wrapper.setFilterName(searchCond.getAttributeCond().getSchema());
            wrapper.setType(searchCond.getAttributeCond().getType());
            wrapper.setFilterValue(searchCond.getAttributeCond().getExpression());
        }
        if (searchCond.getMembershipCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.MEMBERSHIP);
            RoleTO role = new RoleTO();
            role.setId(searchCond.getMembershipCond().getRoleId().longValue());
            role.setName(searchCond.getMembershipCond().getRoleName());
            wrapper.setFilterName(role.getDisplayName());
        }
        if (searchCond.getResourceCond() != null) {
            wrapper.setFilterType(SearchCondWrapper.FilterType.RESOURCE);
            wrapper.setFilterName(searchCond.getResourceCond().getResourceName());
        }
        wrapper.setNotOperator(searchCond.getType() == NodeCond.Type.NOT_LEAF);
        return wrapper;
    }

    public NodeCond buildSearchCond() {
        return this.buildSearchCond(this.searchConditionList);
    }

    private NodeCond buildSearchCond(List<SearchCondWrapper> conditions) {
        SearchCondWrapper searchConditionWrapper = conditions.get(conditions.size() - 1);
        LOG.debug("Search conditions: fname {}; ftype {}; fvalue {}; OP {}; type {}; isnot {}", new Object[]{searchConditionWrapper.getFilterName(), searchConditionWrapper.getFilterType(), searchConditionWrapper.getFilterValue(), searchConditionWrapper.getOperationType(), searchConditionWrapper.getType(), searchConditionWrapper.isNotOperator()});
        NodeCond nodeCond = null;
        switch (10.$SwitchMap$org$syncope$console$commons$SearchCondWrapper$FilterType[searchConditionWrapper.getFilterType().ordinal()]) {
            case 1: {
                SyncopeUserCond attributeCond;
                String schema = searchConditionWrapper.getFilterName();
                if (((List)this.dnames.getObject()).contains(schema)) {
                    attributeCond = new SyncopeUserCond();
                    nodeCond = searchConditionWrapper.isNotOperator() ? NodeCond.getNotLeafCond((SyncopeUserCond)attributeCond) : NodeCond.getLeafCond((SyncopeUserCond)attributeCond);
                } else {
                    attributeCond = new AttributeCond();
                    nodeCond = searchConditionWrapper.isNotOperator() ? NodeCond.getNotLeafCond((AttributeCond)attributeCond) : NodeCond.getLeafCond((AttributeCond)attributeCond);
                }
                attributeCond.setSchema(schema);
                attributeCond.setType(searchConditionWrapper.getType());
                attributeCond.setExpression(searchConditionWrapper.getFilterValue());
                break;
            }
            case 2: {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setRoleId(Long.valueOf(RoleTO.fromDisplayName((String)searchConditionWrapper.getFilterName())));
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((MembershipCond)membershipCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((MembershipCond)membershipCond);
                break;
            }
            case 3: {
                ResourceCond resourceCond = new ResourceCond();
                resourceCond.setResourceName(searchConditionWrapper.getFilterName());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((ResourceCond)resourceCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((ResourceCond)resourceCond);
                break;
            }
        }
        LOG.debug("Processed condition {}", nodeCond);
        if (conditions.size() > 1) {
            List<SearchCondWrapper> subList = conditions.subList(0, conditions.size() - 1);
            nodeCond = SearchCondWrapper.OperationType.OR.equals((Object)searchConditionWrapper.getOperationType()) ? NodeCond.getOrCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList)) : NodeCond.getAndCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList));
        }
        return nodeCond;
    }

    static /* synthetic */ List access$000(UserSearchPanel x0) {
        return x0.ATTRIBUTES_NOTINCLUDED;
    }

    static /* synthetic */ SchemaRestClient access$100(UserSearchPanel x0) {
        return x0.schemaRestClient;
    }

    static /* synthetic */ RoleRestClient access$200(UserSearchPanel x0) {
        return x0.roleRestClient;
    }

    static /* synthetic */ ResourceRestClient access$300(UserSearchPanel x0) {
        return x0.resourceRestClient;
    }

    static /* synthetic */ IModel access$400(UserSearchPanel x0) {
        return x0.attributeTypes;
    }

    static /* synthetic */ IModel access$500(UserSearchPanel x0) {
        return x0.filterTypes;
    }

    static /* synthetic */ IModel access$700(UserSearchPanel x0) {
        return x0.dnames;
    }

    static /* synthetic */ IModel access$800(UserSearchPanel x0) {
        return x0.unames;
    }

    static /* synthetic */ IModel access$900(UserSearchPanel x0) {
        return x0.ronames;
    }

    static /* synthetic */ IModel access$1000(UserSearchPanel x0) {
        return x0.renames;
    }
}

