/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.extensions.converter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoConverter
implements ConditionalGenericConverter,
ApplicationContextAware {
    private Map<Class<?>, GenericDao<?, Serializable>> daoMap;
    private final ConversionService service;

    public GenericDaoConverter(ConversionService service) {
        this.service = service;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericDao<?, Serializable> dao = this.getDaoForDomainType(targetType.getType());
        Serializable id = (Serializable)this.service.convert(source, ClassUtils.getIdClass(dao.getClass()));
        return dao.readByPrimaryKey(id);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericDao<?, Serializable> dao = this.getDaoForDomainType(targetType.getType());
        if (dao == null) {
            return false;
        }
        Class idClass = ClassUtils.getIdClass(dao.getClass());
        return this.service.canConvert(sourceType.getType(), idClass);
    }

    private GenericDao<?, Serializable> getDaoForDomainType(Class<?> domainType) {
        return this.daoMap.get(domainType);
    }

    public void setApplicationContext(ApplicationContext context) {
        Collection daos = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, GenericDao.class).values();
        this.daoMap = new HashMap(daos.size());
        for (GenericDao dao : daos) {
            Class domainClass = ClassUtils.getDomainClass(dao.getClass());
            this.daoMap.put(domainClass, dao);
        }
    }
}

