/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.extensions.beans;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoSupport;
import org.synyx.hades.domain.Persistable;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassPropertyEditor<T extends Serializable>
extends PropertyEditorSupport {
    private final GenericDao<?, T> dao;
    private final PropertyEditorRegistry registry;

    public DomainClassPropertyEditor(GenericDao<?, T> dao, PropertyEditorRegistry registry) {
        Assert.notNull(dao);
        Assert.notNull((Object)registry);
        this.dao = dao;
        this.registry = registry;
    }

    @Override
    public void setAsText(String idAsString) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)idAsString)) {
            this.setValue(null);
            return;
        }
        this.setValue(this.dao.readByPrimaryKey(this.getId(idAsString)));
    }

    @Override
    public String getAsText() {
        Object entity = this.getValue();
        if (null == entity) {
            return null;
        }
        Object id = this.getId(entity);
        return id == null ? null : id.toString();
    }

    private Object getId(Object entity) {
        if (entity instanceof Persistable) {
            return new GenericDaoSupport.PersistableEntityInformation().getId(entity);
        }
        return new GenericDaoSupport.ReflectiveEntityInformation(entity.getClass()).getId(entity);
    }

    private T getId(String idAsString) {
        Class idClass = ClassUtils.getIdClass(this.dao.getClass());
        PropertyEditor idEditor = this.registry.findCustomEditor(idClass, null);
        if (idEditor != null) {
            idEditor.setAsText(idAsString);
            return (T)((Serializable)idEditor.getValue());
        }
        return (T)((Serializable)new SimpleTypeConverter().convertIfNecessary((Object)idAsString, idClass));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DomainClassPropertyEditor that = (DomainClassPropertyEditor)obj;
        return this.dao.equals(that.dao) && this.registry.equals(that.registry);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode += this.dao.hashCode() * 32;
        return hashCode += this.registry.hashCode() * 32;
    }
}

