/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.extensions.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.extensions.beans.DomainClassPropertyEditor;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoPropertyEditorRegistrar
implements PropertyEditorRegistrar,
ApplicationContextAware {
    private final Map<Class<?>, GenericDao<?, Serializable>> daoMap = new HashMap();

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        for (Map.Entry<Class<?>, GenericDao<?, Serializable>> entry : this.daoMap.entrySet()) {
            registry.registerCustomEditor(entry.getKey(), new DomainClassPropertyEditor<Serializable>(entry.getValue(), registry));
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        Collection daos = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, GenericDao.class).values();
        for (GenericDao dao : daos) {
            this.daoMap.put(this.getDomainClass(dao), dao);
        }
    }

    private Class<?> getDomainClass(GenericDao<?, ?> dao) {
        return ClassUtils.getDomainClass(dao.getClass());
    }
}

