/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.ejb.HibernateEntityManager;
import org.synyx.hades.dao.ExtendedGenericDao;
import org.synyx.hades.dao.orm.AbstractExtendedGenericJpaDao;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.PageImpl;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Persistable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHibernateJpaDao<T, PK extends Serializable>
extends AbstractExtendedGenericJpaDao<T, PK> {
    public static <T extends Persistable<PK>, PK extends Serializable> ExtendedGenericDao<T, PK> create(EntityManager entityManager, Class<T> domainClass) {
        GenericHibernateJpaDao<T, PK> dao = new GenericHibernateJpaDao<T, PK>();
        dao.setEntityManager(entityManager);
        dao.setDomainClass(domainClass);
        dao.validate();
        return dao;
    }

    @Override
    public List<T> readByExample(Collection<T> examples) {
        return this.readByExample((Sort)null, examples);
    }

    @Override
    public List<T> readByExample(Sort sort, Collection<T> examples) {
        Criteria criteria = this.applyExamples(examples);
        this.applySorting(criteria, sort);
        return criteria.list();
    }

    @Override
    public Page<T> readByExample(Pageable pageable, Collection<T> examples) {
        if (null == examples || examples.isEmpty()) {
            return this.readAll(pageable);
        }
        Criteria countCriteria = this.applyExamples(examples);
        countCriteria.setProjection(Projections.rowCount());
        Integer count = (Integer)countCriteria.uniqueResult();
        Criteria listCriteria = this.applyExamples(examples);
        this.applyPagination(listCriteria, pageable);
        return new PageImpl(listCriteria.list(), pageable, count.intValue());
    }

    @Override
    public void deleteByExample(Collection<T> examples) {
        for (T entity : this.readByExample(examples)) {
            this.delete(entity);
        }
    }

    private Criteria applyExamples(Collection<T> examples) {
        Criteria criteria = this.getEntityManager().getSession().createCriteria(this.getDomainClass());
        for (T example : examples) {
            Example criteriaExample = Example.create(example);
            criteria.add((Criterion)criteriaExample);
        }
        return criteria;
    }

    private void applySorting(Criteria criteria, Sort sort) {
        if (null == sort) {
            return;
        }
        for (Sort.Property property : sort) {
            Order order = property.isAscending() ? Order.asc((String)property.getName()) : Order.desc((String)property.getName());
            criteria.addOrder(order);
        }
    }

    protected HibernateEntityManager getEntityManager() {
        return (HibernateEntityManager)super.getEntityManager();
    }

    private void applyPagination(Criteria criteria, Pageable pageable) {
        if (null == pageable) {
            return;
        }
        criteria.setFirstResult(pageable.getFirstItem());
        criteria.setMaxResults(pageable.getPageSize());
        this.applySorting(criteria, pageable.getSort());
    }

    @Override
    public void validate() {
        super.validate();
        this.assertEntityManagerClass(HibernateEntityManager.class);
    }
}

