/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.synyx.hades.dao.query.AbstractHadesQuery;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryExtractor;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;

final class NamedHadesQuery
extends AbstractHadesQuery {
    private static final Log LOG = LogFactory.getLog(NamedHadesQuery.class);
    private String queryName;
    private QueryExtractor extractor;

    private NamedHadesQuery(QueryMethod method, EntityManager em) {
        super(method, em);
        this.queryName = method.getNamedQueryName();
        this.extractor = method.getQueryExtractor();
        em.createNamedQuery(this.queryName);
    }

    public static HadesQuery lookupFrom(QueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up named query %s", queryName));
        }
        try {
            boolean cannotExtractQuery;
            NamedHadesQuery query = new NamedHadesQuery(method, em);
            Parameters parameters = method.getParameters();
            if (parameters.hasSortParameter()) {
                throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query! Use @Query instead!", method));
            }
            boolean isPaging = parameters.hasPageableParameter();
            boolean bl = cannotExtractQuery = !method.getQueryExtractor().canExtractQuery();
            if (isPaging && cannotExtractQuery) {
                throw QueryCreationException.create(method, "Cannot use Pageable parameter in query methods with your persistence provider!");
            }
            if (parameters.hasPageableParameter()) {
                LOG.info((Object)String.format("Finder method %s is backed by a NamedQuery but contains a Pageble parameter! Sorting deliviered via this Pageable will not be applied!", method));
            }
            return query;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected Query createQuery(EntityManager em, ParameterBinder binder) {
        return em.createNamedQuery(this.queryName);
    }

    protected Query createCountQuery(EntityManager em, ParameterBinder binder) {
        Query query = this.createQuery(em, binder);
        String queryString = this.extractor.extractQueryString(query);
        return em.createQuery(QueryUtils.createCountQueryFor(queryString));
    }
}

