/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.Param;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parameter {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String PARAM_ON_SPECIAL = String.format("You must not user @%s on a parameter typed %s or %s", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private static final String NAMED_PARAMETER_TEMPLATE = ":%s";
    private static final String POSITION_PARAMETER_TEMPLATE = "?%s";
    private final Class<?> type;
    private final Set<Annotation> annotations;
    private final Parameters parameters;
    private final int index;

    public Parameter(Class<?> type, Annotation[] annotations, Parameters parameters, int index) {
        this(type, new HashSet<Annotation>(), parameters, index);
        for (Annotation annotation : annotations) {
            this.annotations.add(annotation);
        }
        if (this.isSpecialParameter() && this.isNamedParameter()) {
            throw new IllegalArgumentException(PARAM_ON_SPECIAL);
        }
    }

    Parameter(Class<?> type, Set<Annotation> annotations, Parameters parameters, int index) {
        Assert.notNull(type);
        Assert.notNull(annotations);
        Assert.notNull((Object)parameters);
        this.parameters = parameters;
        this.index = index;
        this.type = type;
        this.annotations = annotations;
    }

    Parameter(Parameter parameter, Parameters parameters, int index) {
        this(parameter.type, parameter.annotations, parameters, index);
    }

    boolean isFirst() {
        return this.index == 0;
    }

    public Parameter getNext() {
        return this.parameters.getParameter(this.index + 1);
    }

    Parameter getPrevious() {
        return this.parameters.getParameter(this.index - 1);
    }

    public boolean isSpecialParameter() {
        return TYPES.contains(this.type);
    }

    public boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getPlaceholder() {
        if (this.isNamedParameter()) {
            return String.format(NAMED_PARAMETER_TEMPLATE, this.getParameterName());
        }
        return String.format(POSITION_PARAMETER_TEMPLATE, this.getParameterPosition());
    }

    public int getParameterPosition() {
        return this.parameters.getPlaceholderPosition(this);
    }

    public boolean isNamedParameter() {
        return this.getParameterName() != null;
    }

    public String getParameterName() {
        for (Annotation annotation : this.annotations) {
            if (!(annotation instanceof Param)) continue;
            return ((Param)annotation).value();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type.getName());
        builder.append(StringUtils.collectionToDelimitedString(this.annotations, (String)" "));
        return builder.toString();
    }

    public boolean isPageable() {
        return Pageable.class.isAssignableFrom(this.type);
    }

    public boolean isSort() {
        return Sort.class.isAssignableFrom(this.type);
    }
}

