/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.Assert;
import org.synyx.hades.dao.Param;
import org.synyx.hades.dao.query.Parameter;
import org.synyx.hades.dao.query.ParameterOutOfBoundsException;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parameters
implements Iterable<Parameter> {
    static final List<Class<?>> TYPES = Arrays.asList(Pageable.class, Sort.class);
    private static final String ALL_OR_NOTHING = String.format("Either use @%s on all parameters except %s and %s typed once, or none at all!", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private final int pageableIndex;
    private final int sortIndex;
    private final List<Parameter> parameters;

    public Parameters(Method method) {
        Assert.notNull((Object)method);
        this.parameters = new ArrayList<Parameter>();
        List<Class<?>> types = Arrays.asList(method.getParameterTypes());
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < types.size(); ++i) {
            this.parameters.add(new Parameter(types.get(i), annotations[i], this, i));
        }
        this.pageableIndex = types.indexOf(Pageable.class);
        this.sortIndex = types.indexOf(Sort.class);
        this.assertEitherAllParamAnnotatedOrNone();
    }

    private Parameters(List<Parameter> originals) {
        this.parameters = new ArrayList<Parameter>();
        int pageableIndexTemp = -1;
        int sortIndexTemp = -1;
        for (int i = 0; i < originals.size(); ++i) {
            Parameter original = originals.get(i);
            this.parameters.add(new Parameter(original, this, i));
            pageableIndexTemp = original.isPageable() ? i : -1;
            sortIndexTemp = original.isSort() ? i : -1;
        }
        this.pageableIndex = pageableIndexTemp;
        this.sortIndex = sortIndexTemp;
    }

    public boolean hasPageableParameter() {
        return this.pageableIndex != -1;
    }

    public int getPageableIndex() {
        return this.pageableIndex;
    }

    public boolean hasSortParameter() {
        return this.sortIndex != -1;
    }

    public Parameter getParameter(int index) {
        try {
            return this.parameters.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParameterOutOfBoundsException(e);
        }
    }

    public boolean hasSpecialParameter() {
        return this.hasSortParameter() || this.hasPageableParameter();
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public Parameters getBindableParameters() {
        ArrayList<Parameter> bindables = new ArrayList<Parameter>();
        for (Parameter candidate : this) {
            if (!candidate.isBindable()) continue;
            bindables.add(candidate);
        }
        return new Parameters(bindables);
    }

    int getPlaceholderPosition(Parameter parameter) {
        return parameter.isSpecialParameter() ? 0 : this.getPlaceholderPositionRecursively(parameter);
    }

    private int getPlaceholderPositionRecursively(Parameter parameter) {
        int result = parameter.isSpecialParameter() ? 0 : 1;
        return parameter.isFirst() ? result : result + this.getPlaceholderPositionRecursively(parameter.getPrevious());
    }

    private void assertEitherAllParamAnnotatedOrNone() {
        boolean annotationFound = false;
        for (Parameter parameter : this.getBindableParameters()) {
            if (parameter.isNamedParameter()) {
                Assert.isTrue((annotationFound || parameter.isFirst() ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
                annotationFound = true;
                continue;
            }
            Assert.isTrue((!annotationFound ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
        }
    }

    public static boolean isBindable(Class<?> type) {
        return !TYPES.contains(type);
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameters.iterator();
    }
}

