/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.QueryHint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.synyx.hades.dao.Query;
import org.synyx.hades.dao.query.AbstractHadesQuery;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryCreator;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;

final class SimpleHadesQuery
extends AbstractHadesQuery {
    private static final Log LOG = LogFactory.getLog(SimpleHadesQuery.class);
    private final String queryString;
    private final String alias;
    private final List<QueryHint> hints;

    SimpleHadesQuery(QueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        this.queryString = queryString;
        this.alias = QueryUtils.detectAlias(queryString);
        this.hints = method.getHints();
    }

    SimpleHadesQuery(QueryMethod method, EntityManager em) {
        this(method, em, new QueryCreator(method).constructQuery());
    }

    protected javax.persistence.Query createQuery(EntityManager em, ParameterBinder binder) {
        String query = QueryUtils.applySorting(this.queryString, binder.getSort(), this.alias);
        return this.applyHints(em.createQuery(query));
    }

    protected javax.persistence.Query createCountQuery(EntityManager em, ParameterBinder binder) {
        String query = QueryUtils.createCountQueryFor(this.queryString);
        return this.applyHints(em.createQuery(query));
    }

    private javax.persistence.Query applyHints(javax.persistence.Query query) {
        for (QueryHint hint : this.hints) {
            query.setHint(hint.name(), (Object)hint.value());
        }
        return query;
    }

    public static HadesQuery fromHadesAnnotation(QueryMethod finderMethod, EntityManager em) {
        Query annotation;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up Hades query for method %s", finderMethod.getName()));
        }
        return null == (annotation = finderMethod.getQueryAnnotation()) ? null : new SimpleHadesQuery(finderMethod, em, annotation.value());
    }

    public static HadesQuery construct(QueryMethod queryMethod, EntityManager em) {
        if (queryMethod.isModifyingQuery()) {
            throw QueryCreationException.create(queryMethod, "Cannot create query from method name for modifying query. Use @Query or @NamedQuery to declare the query to execute. Do not use CREATE as strategy to lookup queries!");
        }
        return new SimpleHadesQuery(queryMethod, em);
    }
}

