/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.ExtendedGenericDao;
import org.synyx.hades.dao.GenericDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassUtils {
    private static final List<String> HADES_DAO_INTERFACE_NAMES = Arrays.asList(GenericDao.class.getName(), ExtendedGenericDao.class.getName());

    private ClassUtils() {
    }

    public static Class<?> getDomainClass(Class<?> clazz) {
        return ClassUtils.getGenericType(clazz, 0);
    }

    public static Class<? extends Serializable> getIdClass(Class<?> clazz) {
        return ClassUtils.getGenericType(clazz, 1);
    }

    private static Class<?> getGenericType(Class<?> clazz, int index) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parammeterizedType;
            if (type instanceof ParameterizedType && ClassUtils.isGenericDao(parammeterizedType = (ParameterizedType)type)) {
                Type result = parammeterizedType.getActualTypeArguments()[index];
                return (Class)(result instanceof ParameterizedType ? ((ParameterizedType)result).getRawType() : result);
            }
            Class<?> result = ClassUtils.getGenericType((Class)type, index);
            if (null == result) continue;
            return result;
        }
        return null;
    }

    public static Class<?> getReturnedDomainClass(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return method.getReturnType();
    }

    private static boolean isGenericDao(ParameterizedType type) {
        return GenericDao.class.isAssignableFrom((Class)type.getRawType());
    }

    public static boolean isHadesDaoInterface(Class<?> interfaze) {
        return ClassUtils.isHadesDaoInterface(interfaze.getName());
    }

    public static boolean isHadesDaoInterface(String interfaceName) {
        return HADES_DAO_INTERFACE_NAMES.contains(interfaceName);
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        try {
            Class<?> emType = Class.forName(type);
            emType.cast(em);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static boolean isExtendedDaoInterface(Class<?> daoInterface) {
        return ExtendedGenericDao.class.isAssignableFrom(daoInterface);
    }

    public static int getNumberOfOccurences(Method method, Class<?> type) {
        int result = 0;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (!type.equals(clazz)) continue;
            ++result;
        }
        return result;
    }

    public static void assertReturnType(Method method, Class<?> ... types) {
        if (!Arrays.asList(types).contains(method.getReturnType())) {
            throw new IllegalStateException("Method has to have one of the following return types! " + Arrays.toString(types));
        }
    }

    public static boolean isOfType(Object object, Collection<Class<?>> types) {
        if (null == object) {
            return false;
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return Arrays.asList(method.getParameterTypes()).contains(type);
    }

    public static String getEntityName(Class<?> domainClass) {
        Entity entity = domainClass.getAnnotation(Entity.class);
        boolean hasName = null != entity && StringUtils.hasText((String)entity.name());
        return hasName ? entity.name() : domainClass.getSimpleName();
    }

    public static void unwrapReflectionException(Exception ex) throws Throwable {
        if (ex instanceof InvocationTargetException) {
            throw ((InvocationTargetException)ex).getTargetException();
        }
        throw ex;
    }
}

