/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.config;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.NoDaoBean;
import org.synyx.hades.dao.config.DaoConfigContext;
import org.synyx.hades.dao.config.DaoContext;
import org.synyx.hades.dao.config.TypeFilterParser;
import org.synyx.hades.util.ClassUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DaoConfigDefinitionParser
implements BeanDefinitionParser {
    private static final Log LOG = LogFactory.getLog(DaoConfigDefinitionParser.class);
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final Class<?> PET_POST_PROCESSOR = PersistenceExceptionTranslationPostProcessor.class;
    private static final String DAO_INTERFACE_POST_PROCESSOR = "org.synyx.hades.dao.orm.DaoInterfaceAwareBeanPostProcessor";

    DaoConfigDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        try {
            DaoConfigContext configContext = new DaoConfigContext(element);
            configContext.validate();
            if (configContext.configureManually()) {
                this.doManualConfiguration(configContext, parserContext);
            } else {
                this.doAutoConfiguration(configContext, parserContext);
            }
        }
        catch (IllegalArgumentException e) {
            parserContext.getReaderContext().error(e.getMessage(), parserContext.extractSource((Object)element));
        }
        this.registerPostProcessors(parserContext);
        return null;
    }

    private void doAutoConfiguration(DaoConfigContext configContext, ParserContext parserContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Triggering auto DAO detection");
        }
        ResourceLoader resourceLoader = parserContext.getReaderContext().getResourceLoader();
        Set<String> daoInterfaces = this.getDaoInterfacesForAutoConfig(configContext, resourceLoader, (ReaderContext)parserContext.getReaderContext());
        for (String daoInterface : daoInterfaces) {
            this.registerGenericDaoFactoryBean(parserContext, DaoContext.fromInterfaceName(daoInterface, configContext));
        }
    }

    private Set<String> getDaoInterfacesForAutoConfig(DaoConfigContext configContext, ResourceLoader loader, ReaderContext readerContext) {
        GenericDaoComponentProvider scanner = new GenericDaoComponentProvider();
        scanner.setResourceLoader(loader);
        TypeFilterParser parser = new TypeFilterParser(loader.getClassLoader(), readerContext);
        parser.parseFilters(configContext.getElement(), scanner);
        Set findCandidateComponents = scanner.findCandidateComponents(configContext.getDaoBasePackageName());
        HashSet<String> interfaceNames = new HashSet<String>();
        for (BeanDefinition definition : findCandidateComponents) {
            interfaceNames.add(definition.getBeanClassName());
        }
        return interfaceNames;
    }

    private void doManualConfiguration(DaoConfigContext context, ParserContext parserContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Triggering manual DAO detection");
        }
        for (DaoContext daoContext : context.getDaoContexts()) {
            this.registerGenericDaoFactoryBean(parserContext, daoContext);
        }
    }

    private void registerGenericDaoFactoryBean(ParserContext parserContext, DaoContext context) {
        Object beanSource = parserContext.extractSource((Object)context.getElement());
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)context.getDaoFactoryClassName());
        beanDefinitionBuilder.addPropertyValue("daoInterface", (Object)context.getInterfaceName());
        beanDefinitionBuilder.addPropertyValue("queryLookupStrategy", (Object)context.getQueryLookupStrategy());
        String entityManagerRef = context.getEntityManagerFactoryRef();
        if (null != entityManagerRef) {
            beanDefinitionBuilder.addPropertyValue("entityManager", (Object)this.getEntityManagerBeanDefinitionFor(entityManagerRef, beanSource));
        }
        String customImplementationBeanName = this.registerCustomImplementation(context, parserContext, beanDefinitionBuilder);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        beanDefinition.setSource(beanSource);
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Registering Hades DAO: ");
            builder.append(context.getBeanName());
            builder.append(" - DAO interface: ");
            builder.append(context.getInterfaceName());
            builder.append(" - Factory: ");
            builder.append(context.getDaoFactoryClassName());
            builder.append(" - Custom implementation: ");
            builder.append(customImplementationBeanName);
            LOG.debug((Object)builder.toString());
        }
        BeanComponentDefinition definition = new BeanComponentDefinition((BeanDefinition)beanDefinition, context.getBeanName());
        parserContext.registerBeanComponent(definition);
    }

    private BeanDefinition getEntityManagerBeanDefinitionFor(String entityManagerFactoryBeanName, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(entityManagerFactoryBeanName);
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private String registerCustomImplementation(DaoContext context, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
        String beanName = context.getImplementationBeanName();
        if (parserContext.getRegistry().containsBeanDefinition(beanName)) {
            beanDefinitionBuilder.addPropertyReference("customDaoImplementation", beanName);
            return beanName;
        }
        if (context.autodetectCustomImplementation()) {
            BeanDefinition beanDefinition = this.detectCustomImplementation(context);
            if (null == beanDefinition) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering custom DAO implementation: " + context.getImplementationBeanName() + " " + beanDefinition.getBeanClassName()));
            }
            parserContext.registerBeanComponent(new BeanComponentDefinition(beanDefinition, beanName));
        } else {
            beanName = context.getCustomImplementationRef();
        }
        beanDefinitionBuilder.addPropertyReference("customDaoImplementation", beanName);
        return beanName;
    }

    private BeanDefinition detectCustomImplementation(DaoContext context) {
        Pattern pattern = Pattern.compile(".*" + context.getImplementationClassName());
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new RegexPatternTypeFilter(pattern));
        Set definitions = provider.findCandidateComponents(context.getDaoBasePackageName());
        return 0 == definitions.size() ? null : (BeanDefinition)definitions.iterator().next();
    }

    private void registerPostProcessors(ParserContext parserContext) {
        AbstractBeanDefinition definition;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!this.hasBean(PAB_POST_PROCESSOR, registry)) {
            definition = BeanDefinitionBuilder.rootBeanDefinition(PAB_POST_PROCESSOR).getBeanDefinition();
            registry.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)registry), (BeanDefinition)definition);
        }
        if (!this.hasBean(PET_POST_PROCESSOR, registry)) {
            definition = BeanDefinitionBuilder.rootBeanDefinition(PET_POST_PROCESSOR).getBeanDefinition();
            registry.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)registry), (BeanDefinition)definition);
        }
        definition = BeanDefinitionBuilder.rootBeanDefinition((String)DAO_INTERFACE_POST_PROCESSOR).getBeanDefinition();
        registry.registerBeanDefinition(BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)registry), (BeanDefinition)definition);
    }

    private boolean hasBean(Class<?> clazz, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", clazz.getName(), "#");
        return registry.containsBeanDefinition(name);
    }

    static class GenericDaoComponentProvider
    extends ClassPathScanningCandidateComponentProvider {
        public GenericDaoComponentProvider() {
            super(false);
            this.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(GenericDao.class));
            this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(NoDaoBean.class));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            boolean isNonHadesInterfaces = !ClassUtils.isHadesDaoInterface(beanDefinition.getBeanClassName());
            boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
            return isNonHadesInterfaces && isTopLevelType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class InterfaceTypeFilter
        extends AssignableTypeFilter {
            public InterfaceTypeFilter(Class<?> targetType) {
                super(targetType);
            }

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                return metadataReader.getClassMetadata().isInterface() && super.match(metadataReader, metadataReaderFactory);
            }
        }
    }
}

