/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.Modifying;
import org.synyx.hades.dao.Query;
import org.synyx.hades.dao.QueryHints;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.dao.query.QueryExtractor;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMethod {
    private final Method method;
    private final Parameters parameters;
    private final Class<?> domainClass;
    private final QueryExtractor extractor;

    public QueryMethod(Method method, Class<?> domainClass, QueryExtractor extractor) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        for (Class<?> type : Parameters.TYPES) {
            if (org.synyx.hades.util.ClassUtils.getNumberOfOccurences(method, type) <= 1) continue;
            throw new IllegalStateException(String.format("Method must only one argument of type %s!", type.getSimpleName()));
        }
        if (org.synyx.hades.util.ClassUtils.hasParameterOfType(method, Pageable.class)) {
            org.synyx.hades.util.ClassUtils.assertReturnType(method, Page.class, List.class);
            if (org.synyx.hades.util.ClassUtils.hasParameterOfType(method, Sort.class)) {
                throw new IllegalStateException("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageble instead!");
            }
        }
        this.method = method;
        this.parameters = new Parameters(method);
        this.domainClass = domainClass;
        this.extractor = extractor;
        Assert.isTrue((!this.isModifyingQuery() || !this.parameters.hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
        if (this.parameters.hasPageableParameter() && !extractor.canExtractQuery()) {
            throw new IllegalArgumentException("You cannot use Pageable as method parameter if your persistence provider cannot extract queries!");
        }
    }

    String getName() {
        return this.method.getName();
    }

    boolean isCorrectNumberOfParameters(int number) {
        return number == this.parameters.getBindableParameters().getNumberOfParameters();
    }

    boolean isValidField(String fieldName) {
        Class<?> returnType = org.synyx.hades.util.ClassUtils.getReturnedDomainClass(this.method);
        if (null != ReflectionUtils.findMethod(returnType, (String)("get" + fieldName))) {
            return true;
        }
        return null != ReflectionUtils.findField(returnType, (String)StringUtils.uncapitalize((String)fieldName));
    }

    String getDomainClassName() {
        return org.synyx.hades.util.ClassUtils.getReturnedDomainClass(this.method).getSimpleName();
    }

    String getEntityName() {
        Class<?> domainClass = org.synyx.hades.util.ClassUtils.getReturnedDomainClass(this.method);
        return org.synyx.hades.util.ClassUtils.getEntityName(domainClass);
    }

    Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    boolean isCollectionQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(List.class, returnType);
    }

    boolean isPageQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(Page.class, returnType);
    }

    boolean isModifyingQuery() {
        return null != AnnotationUtils.findAnnotation((Method)this.method, Modifying.class);
    }

    Parameters getParameters() {
        return this.parameters;
    }

    String getNamedQueryName() {
        return this.domainClass.getSimpleName() + "." + this.method.getName();
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    List<QueryHint> getHints() {
        ArrayList<QueryHint> result = new ArrayList<QueryHint>();
        QueryHints hints = (QueryHints)AnnotationUtils.getAnnotation((Method)this.method, QueryHints.class);
        if (hints != null) {
            result.addAll(Arrays.asList(hints.value()));
        }
        return result;
    }

    public String toString() {
        return this.method.toString();
    }
}

