/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.PageRequest;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageImpl<T>
implements Page<T> {
    private List<T> content;
    private Pageable pageable;
    private long total;

    public PageImpl(List<T> content, Pageable pageable, long total) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        this.content = content;
        this.total = total;
        this.pageable = pageable == null ? new PageRequest(0, content.size()) : pageable;
    }

    public PageImpl(List<T> content) {
        this(content, null, content == null ? 0 : content.size());
    }

    @Override
    public int getNumber() {
        return this.pageable.getPageNumber();
    }

    @Override
    public int getSize() {
        return this.pageable.getPageSize();
    }

    @Override
    public int getTotalPages() {
        return (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    @Override
    public int getNumberOfElements() {
        return this.content.size();
    }

    @Override
    public long getTotalElements() {
        return this.total;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.getNumber() > 0;
    }

    @Override
    public boolean hasNextPage() {
        return (long)((this.getNumber() + 1) * this.getSize()) < this.total;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public List<T> asList() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public Sort getSort() {
        return this.pageable.getSort();
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.content.size() > 0) {
            contentType = this.content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber(), this.getTotalPages(), contentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageImpl)) {
            return false;
        }
        PageImpl that = (PageImpl)obj;
        boolean totalEqual = this.total == that.total;
        boolean contentEqual = this.content.equals(that.content);
        boolean pageableEqual = this.pageable.equals(that.pageable);
        return totalEqual && contentEqual && pageableEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        result = 31 * result + this.pageable.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }
}

