/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain.auditing.support;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.synyx.hades.domain.auditing.Auditable;
import org.synyx.hades.domain.auditing.AuditorAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class AuditingEntityListener<T>
implements InitializingBean,
ConfigurableObject {
    private static final Log LOG;
    private AuditorAware<T> auditorAware;
    private boolean dateTimeForNow;
    private boolean modifyOnCreation;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("AuditingEntityListener.java", Class.forName("org.synyx.hades.domain.auditing.support.AuditingEntityListener"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 54);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.synyx.hades.domain.auditing.support.AuditingEntityListener", "", "", ""), 54);
        LOG = LogFactory.getLog(AuditingEntityListener.class);
    }

    public AuditingEntityListener() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if_1((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((!this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if_1((Configurable)this.getClass().getAnnotation(Configurable.class))) && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if_0((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.dateTimeForNow = true;
        this.modifyOnCreation = true;
        if (!AnnotationBeanConfigurerAspect.ajc$if_1((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if_0((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public void setAuditorAware(AuditorAware<T> auditorAware) {
        this.auditorAware = auditorAware;
    }

    public void setDateTimeForNow(boolean dateTimeForNow) {
        this.dateTimeForNow = dateTimeForNow;
    }

    public void setModifyOnCreation(boolean modifyOnCreation) {
        this.modifyOnCreation = modifyOnCreation;
    }

    @PrePersist
    @PreUpdate
    public void touch(Object target) {
        DateTime now;
        if (!(target instanceof Auditable)) {
            return;
        }
        Auditable auditable = (Auditable)target;
        T auditor = this.touchAuditor(auditable);
        DateTime dateTime = now = this.dateTimeForNow ? this.touchDate(auditable) : null;
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Touched ");
            builder.append(auditable);
            if (now != null) {
                builder.append(" Last modification: ").append(now);
            }
            if (auditor != null) {
                builder.append(" by ");
                builder.append(auditor.toString());
            }
            LOG.debug((Object)builder.toString());
        }
    }

    private T touchAuditor(Auditable<T, ?> auditable) {
        if (this.auditorAware == null) {
            return null;
        }
        T auditor = this.auditorAware.getCurrentAuditor();
        if (auditable.isNew()) {
            auditable.setCreatedBy(auditor);
            if (!this.modifyOnCreation) {
                return auditor;
            }
        }
        auditable.setLastModifiedBy(auditor);
        return auditor;
    }

    private DateTime touchDate(Auditable<T, ?> auditable) {
        DateTime now = new DateTime();
        if (auditable.isNew()) {
            auditable.setCreated(now);
            if (!this.modifyOnCreation) {
                return now;
            }
        }
        auditable.setLastModified(now);
        return now;
    }

    public void afterPropertiesSet() {
        if (this.auditorAware == null) {
            LOG.debug((Object)"No AuditorAware set! Auditing will not be applied!");
        }
    }
}

