/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.synyx.hades.dao.ExtendedGenericDao;
import org.synyx.hades.dao.orm.AbstractExtendedGenericJpaDao;
import org.synyx.hades.domain.Order;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.PageImpl;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Persistable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEclipseLinkJpaDao<T, PK extends Serializable>
extends AbstractExtendedGenericJpaDao<T, PK> {
    public static <T extends Persistable<PK>, PK extends Serializable> ExtendedGenericDao<T, PK> create(EntityManager entityManager, Class<T> domainClass) {
        GenericEclipseLinkJpaDao<T, PK> dao = new GenericEclipseLinkJpaDao<T, PK>();
        dao.setEntityManager(entityManager);
        dao.setDomainClass(domainClass);
        dao.validate();
        return dao;
    }

    @Override
    public List<T> readByExample(Collection<T> examples) {
        return this.readByExample((Sort)null, examples);
    }

    @Override
    public List<T> readByExample(Sort sort, Collection<T> examples) {
        ReadAllQuery query = new ReadAllQuery();
        this.applyExamples(query, examples);
        this.applySorting(query, sort);
        return (List)this.executeQuery((DatabaseQuery)query);
    }

    @Override
    public Page<T> readByExample(Pageable pageable, Collection<T> examples) {
        if (null == examples || examples.isEmpty()) {
            return this.readAll(pageable);
        }
        ReportQuery countQuery = new ReportQuery();
        this.applyExamples((ReadAllQuery)countQuery, examples);
        countQuery.addCount();
        Vector totals = (Vector)this.executeQuery((DatabaseQuery)countQuery);
        Integer total = (Integer)((ReportQueryResult)totals.get(0)).getByIndex(0);
        ReadAllQuery query = new ReadAllQuery();
        this.applyExamples(query, examples);
        this.applyPagination(query, pageable);
        List entities = (List)this.executeQuery((DatabaseQuery)query);
        return new PageImpl(entities, pageable, total.intValue());
    }

    @Override
    public void deleteByExample(Collection<T> examples) {
        for (T entity : this.readByExample(examples)) {
            this.delete(this.getEntityManager().merge(entity));
        }
    }

    private <S> S executeQuery(DatabaseQuery query) {
        return (S)this.getEntityManager().getServerSession().executeQuery(query);
    }

    private void applySorting(ReadAllQuery query, Sort sort) {
        if (null == sort) {
            return;
        }
        for (Sort.Property property : sort) {
            Expression expression = new ExpressionBuilder().get(property.getName());
            if (Order.ASCENDING.equals((Object)property.getOrder())) {
                expression.ascending();
            } else {
                expression.descending();
            }
            query.addOrdering(expression);
        }
    }

    private void applyExamples(ReadAllQuery query, Collection<T> examples) {
        if (null == examples) {
            return;
        }
        for (T example : examples) {
            query.setExampleObject(example);
        }
    }

    private void applyPagination(ReadAllQuery query, Pageable pageable) {
        if (null == pageable) {
            return;
        }
        query.setFirstResult(pageable.getFirstItem());
        query.setMaxRows(pageable.getFirstItem() + pageable.getPageSize());
        this.applySorting(query, pageable.getSort());
    }

    protected JpaEntityManager getEntityManager() {
        return (JpaEntityManager)super.getEntityManager();
    }

    @Override
    public void validate() {
        super.validate();
        this.assertEntityManagerClass(JpaEntityManager.class);
    }
}

