/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoSupport;
import org.synyx.hades.dao.query.QueryUtils;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.PageImpl;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class GenericJpaDao<T, PK extends Serializable>
extends GenericDaoSupport<T>
implements GenericDao<T, PK> {
    public static <T, PK extends Serializable> GenericDao<T, PK> create(EntityManager entityManager, Class<T> domainClass) {
        GenericJpaDao<T, PK> dao = new GenericJpaDao<T, PK>();
        dao.setEntityManager(entityManager);
        dao.setDomainClass(domainClass);
        dao.validate();
        return dao;
    }

    @Override
    public void delete(T entity) {
        this.getEntityManager().remove(entity);
    }

    @Override
    public void delete(List<T> entities) {
        if (null == entities || entities.isEmpty()) {
            return;
        }
        QueryUtils.applyAndBind(this.getDeleteAllQueryString(), entities, this.getEntityManager()).executeUpdate();
    }

    @Override
    public void deleteAll() {
        this.getEntityManager().createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    @Override
    public T readByPrimaryKey(PK primaryKey) {
        Assert.notNull(primaryKey, (String)"The given primaryKey must not be null!");
        return (T)this.getEntityManager().find(this.getDomainClass(), primaryKey);
    }

    @Override
    public boolean exists(PK primaryKey) {
        Assert.notNull(primaryKey, (String)"The given primary key must not be null!");
        return null != this.readByPrimaryKey(primaryKey);
    }

    @Override
    public List<T> readAll() {
        return this.getReadAllQuery().getResultList();
    }

    @Override
    public List<T> readAll(Sort sort) {
        String queryString = QueryUtils.applySorting(this.getReadAllQueryString(), sort);
        Query query = this.getEntityManager().createQuery(queryString);
        return null == sort ? this.readAll() : query.getResultList();
    }

    @Override
    public Page<T> readAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl<T>(this.readAll());
        }
        return this.readPage(pageable, this.getReadAllQueryString());
    }

    @Override
    public Long count() {
        return (Long)this.getEntityManager().createQuery(this.getCountQueryString()).getSingleResult();
    }

    @Override
    public T save(T entity) {
        if (this.getIsNewStrategy().isNew(entity)) {
            this.getEntityManager().persist(entity);
            return entity;
        }
        return (T)this.getEntityManager().merge(entity);
    }

    @Override
    public T saveAndFlush(T entity) {
        T result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    public List<T> save(List<T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        if (entities == null) {
            return result;
        }
        for (T entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    protected Page<T> readPage(Pageable pageable, String query) {
        String queryString = QueryUtils.applySorting(query, pageable.getSort());
        Query jpaQuery = this.getEntityManager().createQuery(queryString);
        jpaQuery.setFirstResult(pageable.getFirstItem());
        jpaQuery.setMaxResults(pageable.getPageSize());
        return new PageImpl(jpaQuery.getResultList(), pageable, this.count());
    }
}

