/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.synyx.hades.dao.orm.GenericJpaDao;
import org.synyx.hades.dao.orm.PersistenceProvider;
import org.synyx.hades.dao.query.QueryUtils;
import org.synyx.hades.domain.Persistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericDaoSupport<T> {
    private EntityManager entityManager;
    private Class<T> domainClass;
    private IsNewStrategy isNewStrategy;

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.validate();
    }

    protected Class<T> getDomainClass() {
        return this.domainClass;
    }

    public void setDomainClass(Class<T> domainClass) {
        this.domainClass = domainClass;
        this.createIsNewStrategy(domainClass);
    }

    protected String getReadAllQueryString() {
        return QueryUtils.getQueryString("select x from %s x", this.getDomainClass());
    }

    protected String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.getDomainClass());
    }

    protected String getCountQueryString() {
        PersistenceProvider provider = PersistenceProvider.fromEntityManager(this.getEntityManager());
        String countQuery = String.format("select count(%s) from %s x", provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.getDomainClass());
    }

    protected Query getReadAllQuery() {
        return this.getEntityManager().createQuery(this.getReadAllQueryString());
    }

    protected void assertEntityManagerClass(Class<? extends EntityManager> clazz) {
        Assert.isInstanceOf(clazz, (Object)this.entityManager, (String)String.format("%s can only be used with %s implementation! Please check configuration or use %s instead!", this.getClass().getSimpleName(), clazz.getSimpleName(), GenericJpaDao.class.getSimpleName()));
    }

    public void validate() {
        if (null == this.entityManager) {
            throw new IllegalStateException("EntityManager must not be null!");
        }
    }

    protected void createIsNewStrategy(Class<?> domainClass) {
        this.isNewStrategy = Persistable.class.isAssignableFrom(domainClass) ? new PersistableIsNewStrategy() : new ReflectiveIsNewStrategy(domainClass);
    }

    protected IsNewStrategy getIsNewStrategy() {
        return this.isNewStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReflectiveIsNewStrategy
    implements IsNewStrategy {
        private static final List<Class<? extends Annotation>> ID_ANNOTATIONS = Arrays.asList(Id.class, EmbeddedId.class);
        private Field field;
        private Method method;

        public ReflectiveIsNewStrategy(Class<?> domainClass) {
            Assert.notNull(domainClass);
            Assert.isTrue((boolean)domainClass.isAnnotationPresent(Entity.class), (String)"Given domain class was not annotated with @Entity!");
            ReflectionUtils.doWithFields(domainClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) {
                    if (ReflectiveIsNewStrategy.this.field != null) {
                        return;
                    }
                    if (ReflectiveIsNewStrategy.this.hasAnnotation(field, ID_ANNOTATIONS)) {
                        ReflectiveIsNewStrategy.this.field = field;
                    }
                }
            });
            if (this.field != null) {
                return;
            }
            ReflectionUtils.doWithMethods(domainClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    if (ReflectiveIsNewStrategy.this.method != null) {
                        return;
                    }
                    if (ReflectiveIsNewStrategy.this.hasAnnotation(method, ID_ANNOTATIONS)) {
                        ReflectiveIsNewStrategy.this.method = method;
                    }
                }
            });
            Assert.isTrue((this.field != null || this.method != null ? 1 : 0) != 0, (String)"No id method or field found!");
        }

        private <A extends Annotation> boolean hasAnnotation(AnnotatedElement annotatedElement, List<Class<? extends A>> annotations) {
            for (Class<A> clazz : annotations) {
                if (annotatedElement.getAnnotation(clazz) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isNew(Object entity) {
            if (this.field != null) {
                ReflectionUtils.makeAccessible((Field)this.field);
                return ReflectionUtils.getField((Field)this.field, (Object)entity) == null;
            }
            ReflectionUtils.makeAccessible((Method)this.method);
            return ReflectionUtils.invokeMethod((Method)this.method, (Object)entity) == null;
        }
    }

    public static class PersistableIsNewStrategy
    implements IsNewStrategy {
        public boolean isNew(Object entity) {
            return ((Persistable)entity).isNew();
        }
    }

    public static interface IsNewStrategy {
        public boolean isNew(Object var1);
    }
}

