/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.config;

import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.config.DaoContext;
import org.synyx.hades.dao.query.QueryLookupStrategy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DaoConfigContext {
    protected static final String DEFAULT_DAO_IMPL_POSTFIX = "Impl";
    protected static final String QUERY_LOOKUP_STRATEGY = "query-lookup-strategy";
    protected static final String DAO_PACKAGE_NAME = "base-package";
    protected static final String DAO_IMPL_POSTFIX = "dao-impl-postfix";
    protected static final String DAO_FACTORY_CLASS_NAME = "factory-class";
    protected static final String ENTITY_MANAGER_FACTORY_REF = "entity-manager-factory-ref";
    private Element element;
    private Set<DaoContext> daoContexts;

    public DaoConfigContext(Element daoConfigElement) {
        Assert.notNull((Object)daoConfigElement, (String)"Element must not be null!");
        this.element = daoConfigElement;
        this.daoContexts = new HashSet<DaoContext>();
        NodeList nodes = daoConfigElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            boolean isElement = 1 == node.getNodeType();
            boolean isDao = "dao".equals(node.getLocalName());
            if (!isElement || !isDao) continue;
            DaoContext daoContext = new DaoContext((Element)node, this);
            daoContext.validate();
            this.daoContexts.add(daoContext);
        }
    }

    public void validate() {
    }

    public Set<DaoContext> getDaoContexts() {
        return this.daoContexts;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean configureManually() {
        return this.daoContexts.size() > 0;
    }

    public QueryLookupStrategy getQueryLookupStrategy() {
        String createFinderQueries = this.element.getAttribute(QUERY_LOOKUP_STRATEGY);
        return StringUtils.hasText((String)createFinderQueries) ? QueryLookupStrategy.fromXml(createFinderQueries) : null;
    }

    protected String getDaoBasePackageName() {
        return this.element.getAttribute(DAO_PACKAGE_NAME);
    }

    protected String getDaoFactoryClassName() {
        String factoryClassName = this.element.getAttribute(DAO_FACTORY_CLASS_NAME);
        return StringUtils.hasText((String)factoryClassName) ? factoryClassName : null;
    }

    protected String getDaoImplPostfix() {
        String postfix = this.element.getAttribute(DAO_IMPL_POSTFIX);
        return StringUtils.hasText((String)postfix) ? postfix : DEFAULT_DAO_IMPL_POSTFIX;
    }

    protected String getEntityManagerFactoryRef() {
        String ref = this.element.getAttribute(ENTITY_MANAGER_FACTORY_REF);
        return StringUtils.hasText((String)ref) ? ref : null;
    }
}

