/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.Assert;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoSupport;
import org.synyx.hades.dao.orm.GenericJpaDao;
import org.synyx.hades.dao.orm.PersistenceProvider;
import org.synyx.hades.dao.query.QueryLookupStrategy;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoFactory {
    private EntityManager entityManager;
    private QueryLookupStrategy queryLookupStrategy = QueryLookupStrategy.getDefault();

    protected GenericDaoFactory() {
    }

    public static GenericDaoFactory create(EntityManager entityManager) {
        if (null == entityManager) {
            throw new IllegalArgumentException("EntityManager must not be null!");
        }
        GenericDaoFactory factory = new GenericDaoFactory();
        factory.setEntityManager(entityManager);
        return factory;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public QueryLookupStrategy getQueryLookupStrategy() {
        return this.queryLookupStrategy;
    }

    public void setQueryLookupStrategy(QueryLookupStrategy queryLookupStrategy) {
        this.queryLookupStrategy = null == queryLookupStrategy ? QueryLookupStrategy.getDefault() : queryLookupStrategy;
    }

    public <T extends GenericDao<?, ?>> T getDao(Class<T> daoInterface) {
        return this.getDao(daoInterface, null);
    }

    public <T extends GenericDao<?, ?>> T getDao(Class<T> daoInterface, Object customDaoImplementation) {
        this.validate(daoInterface, customDaoImplementation);
        try {
            GenericDaoSupport genericJpaDao = this.getDaoClass().newInstance();
            genericJpaDao.setEntityManager(this.entityManager);
            genericJpaDao.setDomainClass(ClassUtils.getDomainClass(daoInterface));
            genericJpaDao.validate();
            ProxyFactory result = new ProxyFactory();
            result.setTarget((Object)genericJpaDao);
            result.setInterfaces(new Class[]{daoInterface});
            result.addAdvice((Advice)new QueryExecuterMethodInterceptor(daoInterface, customDaoImplementation));
            return (T)((GenericDao)result.getProxy());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Class<? extends GenericJpaDao> getDaoClass() {
        return GenericJpaDao.class;
    }

    private boolean hasCustomMethod(Class<? extends GenericDao<?, ?>> daoInterface) {
        boolean hasCustomMethod = false;
        if (ClassUtils.isGenericDaoInterface(daoInterface)) {
            return false;
        }
        for (Method method : daoInterface.getMethods()) {
            boolean customMethodCandidate = this.isCustomMethod(method, daoInterface);
            boolean implementedByBaseClass = method.getDeclaringClass().isAssignableFrom(this.getDaoClass());
            if (!customMethodCandidate || implementedByBaseClass) continue;
            return true;
        }
        return hasCustomMethod;
    }

    private boolean isCustomMethod(Method method, Class<?> daoInterface) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (ClassUtils.isGenericDaoInterface(declaringClass)) {
            return false;
        }
        return !this.isFinderMethod(method, daoInterface);
    }

    private boolean isFinderMethod(Method method, Class<?> daoInterface) {
        return daoInterface.equals(method.getDeclaringClass());
    }

    private void validate(Class<?> daoInterface) {
        Assert.notNull(daoInterface);
        Class<?> domainClass = ClassUtils.getDomainClass(daoInterface);
        if (null == domainClass) {
            throw new IllegalArgumentException("Could not retrieve domain class from interface. Make sure it extends GenericDao.");
        }
    }

    protected void validate(Class<? extends GenericDao<?, ?>> daoInterface, Object customDaoImplementation) {
        this.validate(daoInterface);
        if (null == customDaoImplementation && this.hasCustomMethod(daoInterface)) {
            throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", daoInterface));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryExecuterMethodInterceptor
    implements MethodInterceptor {
        private Map<Method, QueryMethod> queries = new ConcurrentHashMap<Method, QueryMethod>();
        private Object customDaoImplementation;
        private Class<?> daoInterface;

        public QueryExecuterMethodInterceptor(Class<?> daoInterface, Object customDaoImplementation) {
            this.daoInterface = daoInterface;
            this.customDaoImplementation = customDaoImplementation;
            for (Method method : daoInterface.getMethods()) {
                if (!GenericDaoFactory.this.isFinderMethod(method, daoInterface)) continue;
                Class<?> domainClass = ClassUtils.getDomainClass(daoInterface);
                PersistenceProvider extractor = PersistenceProvider.fromEntityManager(GenericDaoFactory.this.entityManager);
                QueryMethod finder = new QueryMethod(method, domainClass, GenericDaoFactory.this.entityManager, extractor, GenericDaoFactory.this.queryLookupStrategy);
                this.queries.put(method, finder);
            }
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (this.isCustomMethodInvocation(invocation)) {
                try {
                    return method.invoke(this.customDaoImplementation, invocation.getArguments());
                }
                catch (Exception e) {
                    ClassUtils.unwrapReflectionException(e);
                }
            }
            if (this.hasQueryFor(method)) {
                return this.queries.get(method).executeQuery(invocation.getArguments());
            }
            return invocation.proceed();
        }

        private boolean hasQueryFor(Method method) {
            return this.queries.containsKey(method);
        }

        private boolean isCustomMethodInvocation(MethodInvocation invocation) {
            if (null == this.customDaoImplementation) {
                return false;
            }
            return GenericDaoFactory.this.isCustomMethod(invocation.getMethod(), this.daoInterface);
        }
    }
}

