/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import javax.persistence.EntityManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoFactoryBean<T extends GenericDao<?, ?>>
extends GenericDaoFactory
implements FactoryBean<T>,
InitializingBean {
    private Class<? extends T> daoInterface;
    private Object customDaoImplementation;

    public static <T extends GenericDao<?, ?>> GenericDaoFactoryBean<T> create(Class<T> daoInterface, EntityManager em) {
        GenericDaoFactoryBean<T> factory = new GenericDaoFactoryBean<T>();
        factory.setDaoInterface(daoInterface);
        factory.setEntityManager(em);
        return factory;
    }

    @Required
    public void setDaoInterface(Class<T> daoInterface) {
        Assert.notNull(daoInterface);
        this.daoInterface = daoInterface;
    }

    public void setCustomDaoImplementation(Object customDaoImplementation) {
        this.customDaoImplementation = customDaoImplementation;
    }

    public T getObject() {
        return this.getDao(this.daoInterface, this.customDaoImplementation);
    }

    public Class<? extends T> getObjectType() {
        return null == this.daoInterface ? GenericDao.class : this.daoInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getEntityManager(), (String)"EntityManager must not be null!");
        this.validate(this.daoInterface, this.customDaoImplementation);
    }
}

