/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.query.Parameter;
import org.synyx.hades.dao.query.ParameterOutOfBoundsException;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;

class QueryCreator {
    private static final Log LOG = LogFactory.getLog(QueryCreator.class);
    private static final String INVALID_PARAMETER_SIZE = "You have to provide method arguments for each query criteria to construct the query correctly!";
    private static final String[] PREFIXES = new String[]{"findBy", "find", "readBy", "read", "getBy", "get"};
    private static final String AND = "And";
    private static final String OR = "Or";
    private static final String KEYWORD_TEMPLATE = "(%s)(?=[A-Z])";
    private static final String PREFIX_TEMPLATE = "^%s(?=[A-Z]).*";
    private QueryMethod method;

    public QueryCreator(QueryMethod finderMethod) {
        this.method = finderMethod;
    }

    String constructQuery() {
        StringBuilder queryBuilder = new StringBuilder(QueryUtils.getQueryString("select x from %s x", this.method.getDomainClassName()));
        queryBuilder.append(" where ");
        String[] orParts = this.split(this.strip(this.method.getName()), OR);
        int parametersBound = 0;
        for (String orPart : orParts) {
            String[] andParts = this.split(orPart, AND);
            StringBuilder andBuilder = new StringBuilder();
            for (String andPart : andParts) {
                Parameters parameters = this.method.getParameters().getBindableParameters();
                try {
                    Part part = new Part(andPart, this.method, parameters.getParameter(parametersBound));
                    andBuilder.append(part.getQueryPart()).append(" and ");
                    parametersBound += part.getNumberOfArguments();
                }
                catch (ParameterOutOfBoundsException e) {
                    throw QueryCreationException.create(this.method, e);
                }
            }
            andBuilder.delete(andBuilder.length() - 5, andBuilder.length());
            queryBuilder.append((CharSequence)andBuilder);
            queryBuilder.append(" or ");
        }
        if (!this.method.isCorrectNumberOfParameters(parametersBound)) {
            throw QueryCreationException.create(this.method, INVALID_PARAMETER_SIZE);
        }
        queryBuilder.delete(queryBuilder.length() - 4, queryBuilder.length());
        String query = queryBuilder.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created query '%s' from method %s", query, this.method.getName()));
        }
        return query;
    }

    private String[] split(String text, String keyword) {
        String regex = String.format(KEYWORD_TEMPLATE, keyword);
        Pattern pattern = Pattern.compile(regex);
        return pattern.split(text);
    }

    private String strip(String methodName) {
        for (String prefix : PREFIXES) {
            String regex = String.format(PREFIX_TEMPLATE, prefix);
            if (!methodName.matches(regex)) continue;
            return methodName.substring(prefix.length());
        }
        return methodName;
    }

    private static class Part {
        private final String part;
        private final Type type;
        private final Parameter parameter;
        private final QueryMethod method;

        public Part(String part, QueryMethod method, Parameter parameter) {
            this.part = part;
            this.type = Type.fromProperty(part, method);
            this.method = method;
            this.parameter = parameter;
        }

        public int getNumberOfArguments() {
            return this.type.getNumberOfArguments();
        }

        public String getQueryPart() {
            String property = this.type.extractProperty(this.part);
            if (!this.method.isValidField(property)) {
                throw QueryCreationException.invalidProperty(this.method, property);
            }
            return this.type.createQueryPart(StringUtils.uncapitalize((String)property), this.parameter);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            BETWEEN("Between", null){

                public int getNumberOfArguments() {
                    return 2;
                }

                public String createQueryPart(String property, Parameter parameter) {
                    String first = parameter.getPlaceholder();
                    String second = parameter.getNext().getPlaceholder();
                    return String.format("x.%s between %s and %s", property, first, second);
                }
            }
            ,
            LESS_THAN("LessThan", "<"),
            GREATER_THAN("GreaterThan", ">"),
            SIMPLE_PROPERTY(null, "=");

            private String keyword;
            private String operator;

            private Type(String keyword, String operator) {
                this.keyword = keyword;
                this.operator = operator;
            }

            public static Type fromProperty(String rawProperty, QueryMethod method) {
                for (Type type : Arrays.asList(BETWEEN, LESS_THAN, GREATER_THAN, SIMPLE_PROPERTY)) {
                    if (!type.supports(rawProperty, method)) continue;
                    return type;
                }
                return SIMPLE_PROPERTY;
            }

            public String createQueryPart(String property, Parameter parameter) {
                return String.format("x.%s %s %s", property, this.operator, parameter.getPlaceholder());
            }

            protected boolean supports(String property, QueryMethod method) {
                if (this.keyword == null) {
                    return true;
                }
                if (method.isValidField(property)) {
                    return false;
                }
                return property.endsWith(this.keyword);
            }

            public int getNumberOfArguments() {
                return 1;
            }

            public String extractProperty(String part) {
                return this.keyword == null ? part : part.substring(0, part.indexOf(this.keyword));
            }
        }
    }
}

