/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.domain.PageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum QueryExecution {
    COLLECTION{

        protected Object doExecute(HadesQuery query, ParameterBinder binder) {
            return binder.bindAndPrepare(query.createJpaQuery(binder)).getResultList();
        }
    }
    ,
    PAGE{

        protected Object doExecute(HadesQuery query, ParameterBinder binder) {
            Query projection = binder.bind(query.createCountQuery(binder));
            Long total = (Long)projection.getSingleResult();
            Query jpaQuery = binder.bindAndPrepare(query.createJpaQuery(binder));
            return new PageImpl(jpaQuery.getResultList(), binder.getPageable(), total);
        }
    }
    ,
    SINGLE_ENTITY{

        protected Object doExecute(HadesQuery query, ParameterBinder binder) {
            return binder.bind(query.createJpaQuery(binder)).getSingleResult();
        }
    }
    ,
    MODIFY{

        protected Object doExecute(HadesQuery query, ParameterBinder binder) {
            return binder.bind(query.createJpaQuery(binder)).executeUpdate();
        }
    };


    public Object execute(HadesQuery query, ParameterBinder binder) {
        try {
            return this.doExecute(query, binder);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    protected abstract Object doExecute(HadesQuery var1, ParameterBinder var2);
}

