/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.NamedHadesQuery;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.SimpleHadesQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QueryLookupStrategy {
    CREATE{

        public HadesQuery resolveQuery(QueryMethod method) {
            return SimpleHadesQuery.construct(method);
        }
    }
    ,
    USE_DECLARED_QUERY{

        public HadesQuery resolveQuery(QueryMethod method) {
            HadesQuery query = SimpleHadesQuery.fromHadesAnnotation(method);
            if (null != query) {
                return query;
            }
            query = NamedHadesQuery.lookupFrom(method);
            if (null != query) {
                return query;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor a Hades Query for method %s!", method));
        }
    }
    ,
    CREATE_IF_NOT_FOUND{

        public HadesQuery resolveQuery(QueryMethod method) {
            try {
                return USE_DECLARED_QUERY.resolveQuery(method);
            }
            catch (IllegalStateException e) {
                return SimpleHadesQuery.construct(method);
            }
        }
    };


    public static QueryLookupStrategy fromXml(String xml) {
        if (null == xml) {
            return QueryLookupStrategy.getDefault();
        }
        return QueryLookupStrategy.valueOf(xml.toUpperCase().replace("-", "_"));
    }

    public static QueryLookupStrategy getDefault() {
        return CREATE_IF_NOT_FOUND;
    }

    public abstract HadesQuery resolveQuery(QueryMethod var1);
}

