/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.Modifying;
import org.synyx.hades.dao.Query;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.dao.query.QueryExecution;
import org.synyx.hades.dao.query.QueryExtractor;
import org.synyx.hades.dao.query.QueryLookupStrategy;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMethod {
    private Method method;
    private Parameters parameters;
    private Class<?> domainClass;
    private HadesQuery hadesQuery;
    private EntityManager em;
    private QueryExtractor extractor;

    public QueryMethod(Method method, Class<?> domainClass, EntityManager em, QueryExtractor extractor, QueryLookupStrategy strategy) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        for (Class<?> type : Parameters.TYPES) {
            if (org.synyx.hades.util.ClassUtils.getNumberOfOccurences(method, type) <= 1) continue;
            throw new IllegalStateException(String.format("Method must only one argument of type %s!", type.getSimpleName()));
        }
        if (org.synyx.hades.util.ClassUtils.hasParameterOfType(method, Pageable.class)) {
            org.synyx.hades.util.ClassUtils.assertReturnType(method, Page.class, List.class);
            if (org.synyx.hades.util.ClassUtils.hasParameterOfType(method, Sort.class)) {
                throw new IllegalStateException("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageble instead!");
            }
        }
        this.method = method;
        this.parameters = new Parameters(method);
        this.domainClass = domainClass;
        this.em = em;
        this.extractor = extractor;
        Assert.isTrue((!this.isModifyingQuery() || !this.parameters.hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
        QueryLookupStrategy strategyToUse = null == strategy ? QueryLookupStrategy.getDefault() : strategy;
        this.hadesQuery = strategyToUse.resolveQuery(this);
    }

    public QueryMethod(Method method, Class<?> domainClass, EntityManager em, QueryExtractor extractor) {
        this(method, domainClass, em, extractor, null);
    }

    String getName() {
        return this.method.getName();
    }

    boolean isCorrectNumberOfParameters(int number) {
        return number == this.parameters.getBindableParameters().getNumberOfParameters();
    }

    boolean isValidField(String fieldName) {
        Class<?> returnType = org.synyx.hades.util.ClassUtils.getReturnedDomainClass(this.method);
        if (null != ReflectionUtils.findMethod(returnType, (String)("get" + fieldName))) {
            return true;
        }
        return null != ReflectionUtils.findField(returnType, (String)StringUtils.uncapitalize((String)fieldName));
    }

    String getDomainClassName() {
        return org.synyx.hades.util.ClassUtils.getReturnedDomainClass(this.method).getSimpleName();
    }

    Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    EntityManager getEntityManager() {
        return this.em;
    }

    boolean isCollectionQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(List.class, returnType);
    }

    boolean isPageQuery() {
        Class<?> returnType = this.method.getReturnType();
        return ClassUtils.isAssignable(Page.class, returnType);
    }

    boolean isModifyingQuery() {
        return null != AnnotationUtils.findAnnotation((Method)this.method, Modifying.class);
    }

    Parameters getParameters() {
        return this.parameters;
    }

    String getNamedQueryName() {
        return this.domainClass.getSimpleName() + "." + this.method.getName();
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    public Object executeQuery(Object ... methodParameters) {
        ParameterBinder executionParameters = new ParameterBinder(this.parameters, methodParameters);
        if (this.isCollectionQuery()) {
            return QueryExecution.COLLECTION.execute(this.hadesQuery, executionParameters);
        }
        if (this.isPageQuery()) {
            return QueryExecution.PAGE.execute(this.hadesQuery, executionParameters);
        }
        if (this.isModifyingQuery()) {
            return QueryExecution.MODIFY.execute(this.hadesQuery, executionParameters);
        }
        return QueryExecution.SINGLE_ENTITY.execute(this.hadesQuery, executionParameters);
    }

    public String toString() {
        return this.method.toString();
    }
}

