/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.util.Assert;
import org.synyx.hades.domain.Sort;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(x) from %s x";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    public static final String READ_ALL_QUERY = "select x from %s x";
    private static final String DEFAULT_ALIAS = "x";
    private static final String COUNT_MATCH = "(?<=select )(.*)(?= from)";
    private static final String COUNT_REPLACEMENT = "count(*)";
    private static final Pattern ALIAS_MATCH;

    private QueryUtils() {
    }

    public static String getQueryString(String template, Class<?> clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException("Class must not be null!");
        }
        return QueryUtils.getQueryString(template, ClassUtils.getEntityName(clazz));
    }

    public static String getQueryString(String template, String clazzName) {
        Assert.hasText((String)clazzName, (String)"Classname must not be null or empty!");
        return String.format(template, clazzName);
    }

    public static String applySorting(String query, Sort sort) {
        return QueryUtils.applySorting(query, sort, DEFAULT_ALIAS);
    }

    public static String applySorting(String query, Sort sort, String alias) {
        if (null == sort) {
            return query;
        }
        Assert.hasText((String)alias);
        StringBuilder builder = new StringBuilder(query);
        builder.append(" order by");
        for (Sort.Property property : sort) {
            builder.append(String.format(" %s.", alias));
            builder.append(property.getName());
            builder.append(" ");
            builder.append(property.getOrder().getJpaValue());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String detectAlias(String query) {
        Matcher matcher = ALIAS_MATCH.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static <T> Query applyAndBind(String queryString, Collection<T> entities, EntityManager entityManager) {
        Assert.notNull((Object)queryString);
        Assert.notNull(entities);
        Assert.notNull((Object)entityManager);
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = QueryUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        for (int i = 0; i < entities.size(); ++i) {
            builder.append(String.format(" %s = ?", alias));
            if (i >= entities.size() - 1) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        for (int i = 0; i < entities.size(); ++i) {
            query.setParameter(i + 1, iterator.next());
        }
        return query;
    }

    public static String createCountQueryFor(String originalQuery) {
        Assert.hasText((String)originalQuery);
        if (originalQuery.startsWith("from")) {
            return String.format("select %s %s", COUNT_REPLACEMENT, originalQuery);
        }
        return originalQuery.replaceFirst(COUNT_MATCH, COUNT_REPLACEMENT);
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?: )+");
        builder.append("([\\w.]*)");
        builder.append("(?: as)*");
        builder.append("(?: )+");
        builder.append("(\\w*)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
    }
}

