/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.synyx.hades.dao.Query;
import org.synyx.hades.dao.query.AbstractHadesQuery;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryCreator;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;

final class SimpleHadesQuery
extends AbstractHadesQuery {
    private static final Log LOG = LogFactory.getLog(SimpleHadesQuery.class);
    private String queryString;
    private String alias;

    private SimpleHadesQuery(QueryMethod method, String queryString) {
        super(method);
        this.queryString = queryString;
        this.alias = QueryUtils.detectAlias(queryString);
    }

    private SimpleHadesQuery(QueryMethod method) {
        this(method, new QueryCreator(method).constructQuery());
    }

    protected javax.persistence.Query createQuery(EntityManager em, ParameterBinder binder) {
        String query = QueryUtils.applySorting(this.queryString, binder.getSort(), this.alias);
        return em.createQuery(query);
    }

    protected javax.persistence.Query createCountQuery(EntityManager em, ParameterBinder binder) {
        String query = QueryUtils.createCountQueryFor(this.queryString);
        query = QueryUtils.applySorting(query, binder.getSort(), this.alias);
        return em.createQuery(query);
    }

    public static HadesQuery fromHadesAnnotation(QueryMethod finderMethod) {
        Query annotation;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up Hades query for method %s", finderMethod.getName()));
        }
        return null == (annotation = finderMethod.getQueryAnnotation()) ? null : new SimpleHadesQuery(finderMethod, annotation.value());
    }

    public static HadesQuery construct(QueryMethod queryMethod) {
        if (queryMethod.isModifyingQuery()) {
            throw QueryCreationException.create(queryMethod, "Cannot create query from method name for modifying query. Use @Query or @NamedQuery to declare the query to execute. Do not use CREATE as strategy to lookup queries!");
        }
        return new SimpleHadesQuery(queryMethod);
    }
}

