/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.synyx.hades.domain.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sort
implements Iterable<Property> {
    public static final Order DEFAULT_ORDER = Order.ASCENDING;
    private List<Property> properties;
    private Order order;

    public Sort(List<Property> properties) {
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.properties = properties;
    }

    public Sort(String ... properties) {
        this(DEFAULT_ORDER, properties);
    }

    public Sort(Order order, String ... properties) {
        if (null == properties || 0 == properties.length) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.properties = new ArrayList<Property>(properties.length);
        this.order = null == order ? DEFAULT_ORDER : order;
        for (String propertyName : properties) {
            this.properties.add(new Property(order, propertyName));
        }
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        boolean orderEqual = this.order.equals((Object)that.order);
        boolean propertiesEqual = ((Object)this.properties).equals(that.properties);
        return orderEqual && propertiesEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.order.hashCode();
        result = 31 * result + ((Object)this.properties).hashCode();
        return result;
    }

    public static class Property {
        private Order order;
        private String property;

        public Property(Order order, String property) {
            if (property == null || "".equals(property.trim())) {
                throw new IllegalArgumentException("Property must not null or empty!");
            }
            this.order = order == null ? DEFAULT_ORDER : order;
            this.property = property;
        }

        public Property(String property) {
            this(DEFAULT_ORDER, property);
        }

        public Order getOrder() {
            return this.order;
        }

        public String getName() {
            return this.property;
        }

        public boolean isAscending() {
            return this.order.equals((Object)Order.ASCENDING);
        }

        public Property with(Order order) {
            return new Property(order, this.property);
        }

        public Sort withProperties(String ... properties) {
            return new Sort(this.order, properties);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.order.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property that = (Property)obj;
            return this.order.equals((Object)that.order) && this.property.equals(that.property);
        }
    }
}

