/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.config;

import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.config.DaoConfigContext;
import org.w3c.dom.Element;

class DaoContext
extends DaoConfigContext {
    private static final String CUSTOM_IMPL_REF = "custom-impl-ref";
    private DaoConfigContext parent;
    private String id;

    public DaoContext(Element element, DaoConfigContext parent) {
        super(element);
        this.parent = parent;
        this.id = element.getAttribute("id");
    }

    public DaoContext(String id, DaoConfigContext parent) {
        super(parent.getElement());
        this.parent = parent;
        this.id = id;
    }

    public static DaoContext fromInterfaceName(String interfaceName, DaoConfigContext parent) {
        String shortName = ClassUtils.getShortName((String)interfaceName);
        String id = StringUtils.uncapitalize((String)shortName);
        final String packageName = interfaceName.substring(0, interfaceName.lastIndexOf(shortName) - 1);
        return new DaoContext(id, parent){

            protected String getDaoBasePackageName() {
                return packageName;
            }
        };
    }

    public void validate() {
        Assert.notNull((Object)this.getId());
    }

    public String getId() {
        return this.id;
    }

    public String getBeanName() {
        return this.id;
    }

    public String getInterfaceName() {
        return this.getDaoBasePackageName() + "." + StringUtils.capitalize((String)this.id);
    }

    public String getImplementationClassName() {
        return StringUtils.capitalize((String)this.id) + this.getDaoImplPostfix();
    }

    public String getImplementationBeanName() {
        return this.id + this.getDaoImplPostfix();
    }

    public boolean autodetectCustomImplementation() {
        return !StringUtils.hasText((String)this.getElement().getAttribute(CUSTOM_IMPL_REF));
    }

    public String getCustomImplementationRef() {
        return this.getElement().getAttribute(CUSTOM_IMPL_REF);
    }

    protected String getDaoBasePackageName() {
        String daoPackageName = this.getElement().getAttribute("base-package");
        return StringUtils.hasText((String)daoPackageName) ? daoPackageName : this.parent.getDaoBasePackageName();
    }

    protected String getDaoImplPostfix() {
        String daoImplPostfix = this.getElement().getAttribute("dao-impl-postfix");
        return StringUtils.hasLength((String)daoImplPostfix) ? daoImplPostfix : this.parent.getDaoImplPostfix();
    }

    protected String getDaoFactoryClassName() {
        String factoryClassName = this.getElement().getAttribute("factory-class");
        return StringUtils.hasText((String)factoryClassName) ? factoryClassName : this.parent.getDaoFactoryClassName();
    }

    protected String getEntityManagerFactoryRef() {
        String ref = this.getElement().getAttribute("entity-manager-factory-ref");
        return StringUtils.hasText((String)ref) ? ref : this.parent.getEntityManagerFactoryRef();
    }

    protected String getTransactionManagerRef() {
        String ref = this.getElement().getAttribute("transaction-manager-ref");
        return StringUtils.hasText((String)ref) ? ref : this.parent.getTransactionManagerRef();
    }
}

