/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoSupport;
import org.synyx.hades.dao.orm.GenericJpaDao;
import org.synyx.hades.dao.orm.PersistenceProvider;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.QueryLookupStrategy;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoFactory {
    private EntityManager entityManager;
    private QueryLookupStrategy queryLookupStrategy = QueryLookupStrategy.getDefault();
    private Map<Method, Method> methodCache = new ConcurrentHashMap<Method, Method>();

    protected GenericDaoFactory() {
    }

    public static GenericDaoFactory create(EntityManager entityManager) {
        if (null == entityManager) {
            throw new IllegalArgumentException("EntityManager must not be null!");
        }
        GenericDaoFactory factory = new GenericDaoFactory();
        factory.setEntityManager(entityManager);
        return factory;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    QueryLookupStrategy getQueryLookupStrategy() {
        return this.queryLookupStrategy;
    }

    public void setQueryLookupStrategy(QueryLookupStrategy queryLookupStrategy) {
        this.queryLookupStrategy = null == queryLookupStrategy ? QueryLookupStrategy.getDefault() : queryLookupStrategy;
    }

    public <T extends GenericDao<?, ?>> T getDao(Class<T> daoInterface) {
        return this.getDao(daoInterface, null);
    }

    public <T extends GenericDao<?, ?>> T getDao(Class<T> daoInterface, Object customDaoImplementation) {
        this.validate(daoInterface, customDaoImplementation);
        try {
            GenericDaoSupport genericJpaDao = this.getDaoClass().newInstance();
            genericJpaDao.setEntityManager(this.entityManager);
            genericJpaDao.setDomainClass(ClassUtils.getDomainClass(daoInterface));
            genericJpaDao.validate();
            ProxyFactory result = new ProxyFactory();
            result.setTarget((Object)genericJpaDao);
            result.setInterfaces(new Class[]{daoInterface});
            this.prepare(result);
            result.addAdvice((Advice)new QueryExecuterMethodInterceptor(daoInterface, customDaoImplementation, genericJpaDao));
            return (T)((GenericDao)result.getProxy());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void prepare(ProxyFactory proxyFactory) {
    }

    protected Class<? extends GenericJpaDao> getDaoClass() {
        return GenericJpaDao.class;
    }

    private boolean hasCustomMethod(Class<? extends GenericDao<?, ?>> daoInterface) {
        boolean hasCustomMethod = false;
        if (ClassUtils.isGenericDaoInterface(daoInterface)) {
            return false;
        }
        for (Method method : daoInterface.getMethods()) {
            if (!this.isCustomMethod(method, daoInterface) || this.isBaseClassMethod(method, daoInterface)) continue;
            return true;
        }
        return hasCustomMethod;
    }

    private boolean isBaseClassMethod(Method method, Class<?> daoInterface) {
        Assert.notNull((Object)method);
        if (method.getDeclaringClass().isAssignableFrom(this.getDaoClass())) {
            return true;
        }
        return !method.equals(this.getBaseClassMethod(method, daoInterface));
    }

    private Method getBaseClassMethod(Method method, Class<?> daoInterface) {
        Assert.notNull((Object)method);
        Method result = this.methodCache.get(method);
        if (null != result) {
            return result;
        }
        result = ClassUtils.getBaseClassMethodFor(method, this.getDaoClass(), daoInterface);
        this.methodCache.put(method, result);
        return result;
    }

    private boolean isCustomMethod(Method method, Class<?> daoInterface) {
        Class<?> declaringClass = method.getDeclaringClass();
        boolean isQueryMethod = declaringClass.equals(daoInterface);
        boolean isHadesDaoInterface = ClassUtils.isGenericDaoInterface(declaringClass);
        boolean isBaseClassMethod = this.isBaseClassMethod(method, daoInterface);
        return !isHadesDaoInterface && !isBaseClassMethod && !isQueryMethod;
    }

    private Iterable<Method> getFinderMethods(Class<?> daoInterface) {
        HashSet<Method> result = new HashSet<Method>();
        for (Method method : daoInterface.getDeclaredMethods()) {
            if (this.isCustomMethod(method, daoInterface) || this.isBaseClassMethod(method, daoInterface)) continue;
            result.add(method);
        }
        return result;
    }

    private void validate(Class<?> daoInterface) {
        Assert.notNull(daoInterface);
        Class<?> domainClass = ClassUtils.getDomainClass(daoInterface);
        if (null == domainClass) {
            throw new IllegalArgumentException("Could not retrieve domain class from interface. Make sure it extends GenericDao.");
        }
    }

    protected void validate(Class<? extends GenericDao<?, ?>> daoInterface, Object customDaoImplementation) {
        this.validate(daoInterface);
        if (null == customDaoImplementation && this.hasCustomMethod(daoInterface)) {
            throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", daoInterface));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryExecuterMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HadesQuery> queries = new ConcurrentHashMap<Method, HadesQuery>();
        private final Object customDaoImplementation;
        private final Class<?> daoInterface;
        private final GenericDaoSupport<?> dao;

        public QueryExecuterMethodInterceptor(Class<?> daoInterface, Object customDaoImplementation, GenericDaoSupport<?> dao) {
            this.daoInterface = daoInterface;
            this.customDaoImplementation = customDaoImplementation;
            this.dao = dao;
            for (Method method : GenericDaoFactory.this.getFinderMethods(daoInterface)) {
                Class<?> domainClass = ClassUtils.getDomainClass(daoInterface);
                PersistenceProvider extractor = PersistenceProvider.fromEntityManager(GenericDaoFactory.this.entityManager);
                QueryMethod finder = new QueryMethod(method, domainClass, extractor);
                this.queries.put(method, GenericDaoFactory.this.queryLookupStrategy.resolveQuery(finder, GenericDaoFactory.this.entityManager));
            }
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (this.isCustomMethodInvocation(invocation)) {
                ReflectionUtils.makeAccessible((Method)method);
                return this.executeMethodOn(this.customDaoImplementation, method, invocation.getArguments());
            }
            if (this.hasQueryFor(method)) {
                return this.queries.get(method).execute(invocation.getArguments());
            }
            Method actualMethod = GenericDaoFactory.this.getBaseClassMethod(method, this.daoInterface);
            return this.executeMethodOn(this.dao, actualMethod, invocation.getArguments());
        }

        private Object executeMethodOn(Object target, Method method, Object[] parameters) throws Throwable {
            try {
                return method.invoke(target, parameters);
            }
            catch (Exception e) {
                ClassUtils.unwrapReflectionException(e);
                throw new IllegalStateException("Should not occur!");
            }
        }

        private boolean hasQueryFor(Method method) {
            return this.queries.containsKey(method);
        }

        private boolean isCustomMethodInvocation(MethodInvocation invocation) {
            if (null == this.customDaoImplementation) {
                return false;
            }
            return GenericDaoFactory.this.isCustomMethod(invocation.getMethod(), this.daoInterface);
        }
    }
}

