/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import javax.persistence.EntityManager;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.support.PersistenceExceptionTranslationInterceptor;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoFactoryBean<T extends GenericDao<?, ?>>
extends GenericDaoFactory
implements FactoryBean<T>,
InitializingBean,
BeanFactoryAware {
    public static final String DEFAULT_TRANSACTION_MANAGER = "transactionManager";
    private Class<? extends T> daoInterface;
    private Object customDaoImplementation;
    private String transactionManagerName;
    private TransactionInterceptor transactionInterceptor;
    private PersistenceExceptionTranslationInterceptor petInterceptor;

    public static <T extends GenericDao<?, ?>> GenericDaoFactoryBean<T> create(Class<T> daoInterface, EntityManager em) {
        GenericDaoFactoryBean<T> factory = new GenericDaoFactoryBean<T>();
        factory.setDaoInterface(daoInterface);
        factory.setEntityManager(em);
        return factory;
    }

    @Required
    public void setDaoInterface(Class<T> daoInterface) {
        Assert.notNull(daoInterface);
        this.daoInterface = daoInterface;
    }

    public void setTransactionManager(String transactionManager) {
        this.transactionManagerName = transactionManager;
    }

    public void setCustomDaoImplementation(Object customDaoImplementation) {
        this.customDaoImplementation = customDaoImplementation;
    }

    public T getObject() {
        return this.getDao(this.daoInterface, this.customDaoImplementation);
    }

    public Class<? extends T> getObjectType() {
        return null == this.daoInterface ? GenericDao.class : this.daoInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getEntityManager(), (String)"EntityManager must not be null!");
        this.validate(this.daoInterface, this.customDaoImplementation);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.petInterceptor = new PersistenceExceptionTranslationInterceptor();
        this.petInterceptor.setBeanFactory(beanFactory);
        this.petInterceptor.afterPropertiesSet();
        this.transactionInterceptor = new TransactionInterceptor(null, (TransactionAttributeSource)new AnnotationTransactionAttributeSource());
        this.transactionInterceptor.setTransactionManagerBeanName(this.transactionManagerName);
        this.transactionInterceptor.setBeanFactory(beanFactory);
        this.transactionInterceptor.afterPropertiesSet();
    }

    @Override
    protected void prepare(ProxyFactory factory) {
        if (this.petInterceptor != null) {
            factory.addAdvice((Advice)this.petInterceptor);
        }
        if (this.transactionInterceptor != null) {
            factory.addAdvice((Advice)this.transactionInterceptor);
        }
    }
}

