/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain;

import org.synyx.hades.domain.Order;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

public class PageRequest
implements Pageable {
    private int page;
    private int size;
    private Sort sort;

    public PageRequest(int page, int size) {
        if (0 > page) {
            throw new IllegalArgumentException("Page index must not be less than zero!");
        }
        if (0 > size) {
            throw new IllegalArgumentException("Page size must not be less than or equal to zero!");
        }
        this.page = page;
        this.size = size;
    }

    public PageRequest(int page, int size, Order order, String ... properties) {
        this(page, size, new Sort(order, properties));
    }

    public PageRequest(int page, int size, Sort sort) {
        this(page, size);
        this.sort = sort;
    }

    public int getPageSize() {
        return this.size;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getFirstItem() {
        return this.page * this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean equals(Object obj) {
        boolean sizeEqual;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean pageEqual = this.page == that.page;
        boolean bl = sizeEqual = this.size == that.size;
        boolean sortEqual = this.sort == null ? that.sort == null : this.sort.equals(that.sort);
        return pageEqual && sizeEqual && sortEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.page;
        result = 31 * result + this.size;
        result = 31 * result + (null == this.sort ? 0 : this.sort.hashCode());
        return result;
    }
}

