/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain.auditing;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.joda.time.DateTime;
import org.synyx.hades.domain.auditing.Auditable;
import org.synyx.hades.domain.auditing.AuditorAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class AuditingAdvice<T> {
    private static final Log LOG = LogFactory.getLog(AuditingAdvice.class);
    private AuditorAware<T> auditorAware;
    private boolean dateTimeForNow = true;
    private boolean modifyOnCreation = true;

    public void setAuditorAware(AuditorAware<T> auditorAware) {
        this.auditorAware = auditorAware;
    }

    public void setDateTimeForNow(boolean dateTimeForNow) {
        this.dateTimeForNow = dateTimeForNow;
    }

    public void setModifyOnCreation(boolean modifyOnCreation) {
        this.modifyOnCreation = modifyOnCreation;
    }

    @Before(value="execution(* org.synyx.hades.dao.GenericDao+.save*(..)) && args(auditable)")
    public void touch(Auditable<T, ?> auditable) {
        DateTime now;
        if (null == auditable) {
            return;
        }
        T auditor = this.touchAuditor(auditable);
        DateTime dateTime = now = this.dateTimeForNow ? this.touchDate(auditable) : null;
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Touched ");
            builder.append(auditable);
            if (null != now) {
                builder.append(" Last modification: ").append(now);
            }
            if (null != auditor) {
                builder.append(" by ");
                builder.append(auditor.toString());
            }
            LOG.debug((Object)builder.toString());
        }
    }

    @Before(value="execution(* org.synyx.hades.dao.GenericDao+.save*(..)) && args(auditables)")
    public void touch(List<?> auditables) {
        for (Object auditable : auditables) {
            if (!(auditable instanceof Auditable)) continue;
            this.touch((Auditable)auditable);
        }
    }

    private T touchAuditor(Auditable<T, ?> auditable) {
        if (null == this.auditorAware) {
            return null;
        }
        T auditor = this.auditorAware.getCurrentAuditor();
        if (auditable.isNew()) {
            auditable.setCreatedBy(auditor);
            if (!this.modifyOnCreation) {
                return auditor;
            }
        }
        auditable.setLastModifiedBy(auditor);
        return auditor;
    }

    private DateTime touchDate(Auditable<T, ?> auditable) {
        DateTime now = new DateTime();
        if (auditable.isNew()) {
            auditable.setCreated(now);
            if (!this.modifyOnCreation) {
                return now;
            }
        }
        auditable.setLastModified(now);
        return now;
    }
}

