/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.util.ClassUtils;
import org.synyx.hades.dao.orm.GenericDaoFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DaoInterfaceAwareBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    private ConfigurableListableBeanFactory context;

    DaoInterfaceAwareBeanPostProcessor() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !GenericDaoFactoryBean.class.isAssignableFrom(beanClass)) {
            return null;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        PropertyValue value = definition.getPropertyValues().getPropertyValue("daoInterface");
        return this.getClassForPropertyValue(value);
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue) {
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            return null;
        }
        try {
            return ClassUtils.resolveClassName((String)className, (ClassLoader)DaoInterfaceAwareBeanPostProcessor.class.getClassLoader());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

