/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.synyx.hades.dao.GenericDao;
import org.synyx.hades.dao.orm.GenericDaoSupport;
import org.synyx.hades.dao.query.QueryUtils;
import org.synyx.hades.domain.Page;
import org.synyx.hades.domain.PageImpl;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;
import org.synyx.hades.domain.Specification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
@Transactional
public class GenericJpaDao<T, PK extends Serializable>
extends GenericDaoSupport<T>
implements GenericDao<T, PK> {
    public static <T, PK extends Serializable> GenericDao<T, PK> create(EntityManager entityManager, Class<T> domainClass) {
        GenericJpaDao<T, PK> dao = new GenericJpaDao<T, PK>();
        dao.setEntityManager(entityManager);
        dao.setDomainClass(domainClass);
        dao.validate();
        return dao;
    }

    @Override
    public void delete(T entity) {
        EntityManager em;
        em.remove((em = this.getEntityManager()).contains(entity) ? entity : em.merge(entity));
    }

    @Override
    public void delete(Collection<? extends T> entities) {
        if (null == entities || entities.isEmpty()) {
            return;
        }
        QueryUtils.applyAndBind(this.getDeleteAllQueryString(), entities, this.getEntityManager()).executeUpdate();
    }

    @Override
    public void deleteAll() {
        this.getEntityManager().createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    @Override
    @Transactional(readOnly=true)
    public T readByPrimaryKey(PK primaryKey) {
        Assert.notNull(primaryKey, (String)"The given primaryKey must not be null!");
        return (T)this.getEntityManager().find(this.getDomainClass(), primaryKey);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean exists(PK primaryKey) {
        Assert.notNull(primaryKey, (String)"The given primary key must not be null!");
        return null != this.readByPrimaryKey(primaryKey);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> readAll() {
        return this.getReadAllQuery().getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> readAll(Specification<T> spec) {
        return this.getQuery(spec, null).getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public Page<T> readAll(Specification<T> spec, Pageable pageable) {
        if (spec == null) {
            return this.readAll(pageable);
        }
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return pageable == null ? new PageImpl(query.getResultList()) : this.readPage(query, pageable, spec);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> readAll(Sort sort) {
        String queryString = QueryUtils.applySorting(this.getReadAllQueryString(), sort);
        TypedQuery query = this.getEntityManager().createQuery(queryString, this.getDomainClass());
        return null == sort ? this.readAll() : query.getResultList();
    }

    @Override
    @Transactional(readOnly=true)
    public Page<T> readAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl<T>(this.readAll());
        }
        return this.readPage(pageable, this.getReadAllQueryString());
    }

    @Override
    @Transactional(readOnly=true)
    public Long count() {
        return (Long)this.getEntityManager().createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    private Long count(Specification<T> spec) {
        return (Long)this.getCountQuery(spec).getSingleResult();
    }

    @Override
    public T save(T entity) {
        if (this.getIsNewStrategy().isNew(entity)) {
            this.getEntityManager().persist(entity);
            return entity;
        }
        return (T)this.getEntityManager().merge(entity);
    }

    @Override
    public T saveAndFlush(T entity) {
        T result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    public List<T> save(Collection<? extends T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        if (entities == null) {
            return result;
        }
        for (T entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    protected Page<T> readPage(Pageable pageable, String query) {
        String queryString = QueryUtils.applySorting(query, pageable.getSort());
        TypedQuery jpaQuery = this.getEntityManager().createQuery(queryString, this.getDomainClass());
        return this.readPage(jpaQuery, pageable, null);
    }

    private Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        query.setFirstResult(pageable.getFirstItem());
        query.setMaxResults(pageable.getPageSize());
        return new PageImpl(query.getResultList(), pageable, this.count(spec));
    }

    private TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getDomainClass());
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select(root);
        if (pageable != null) {
            query.orderBy(this.toOrders(pageable.getSort(), root, builder));
        }
        return this.getEntityManager().createQuery(query);
    }

    private TypedQuery<Long> getCountQuery(Specification<T> spec) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select((Selection)builder.count(root)).distinct(true);
        return this.getEntityManager().createQuery(query);
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query) {
        Assert.notNull(query);
        Root root = query.from(this.getDomainClass());
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private List<Order> toOrders(Sort sort, Root<T> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort == null) {
            return orders;
        }
        for (Sort.Property property : sort) {
            Path expression = root.get(property.getName());
            orders.add(property.isAscending() ? cb.asc((Expression)expression) : cb.desc((Expression)expression));
        }
        return orders;
    }
}

