/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.eclipse.persistence.jpa.JpaQuery;
import org.hibernate.ejb.HibernateQuery;
import org.synyx.hades.dao.query.QueryExtractor;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum PersistenceProvider implements QueryExtractor
{
    HIBERNATE("org.hibernate.ejb.HibernateEntityManager"){

        public String extractQueryString(Query query) {
            return ((HibernateQuery)query).getHibernateQuery().getQueryString();
        }

        protected String getCountQueryPlaceholder() {
            return "*";
        }
    }
    ,
    ECLIPSELINK("org.eclipse.persistence.jpa.JpaEntityManager"){

        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }
    }
    ,
    OPEN_JPA("org.apache.openjpa.persistence.OpenJPAEntityManager"){

        public String extractQueryString(Query query) {
            return ((OpenJPAQuery)query).getQueryString();
        }
    }
    ,
    GENERIC_JPA("javax.persistence.EntityManager"){

        public String extractQueryString(Query query) {
            return null;
        }

        public boolean canExtractQuery() {
            return false;
        }
    };

    private String entityManagerClassName;

    private PersistenceProvider(String entityManagerClassName) {
        this.entityManagerClassName = entityManagerClassName;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            if (!ClassUtils.isEntityManagerOfType(em, provider.entityManagerClassName)) continue;
            return provider;
        }
        return GENERIC_JPA;
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    protected String getCountQueryPlaceholder() {
        return "x";
    }
}

