/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.query.Parameter;
import org.synyx.hades.dao.query.ParameterOutOfBoundsException;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;
import org.synyx.hades.domain.Order;

class QueryCreator {
    private static final Logger LOG = LoggerFactory.getLogger(QueryCreator.class);
    private static final String INVALID_PARAMETER_SIZE = "You have to provide method arguments for each query criteria to construct the query correctly!";
    private static final String AND = "And";
    private static final String OR = "Or";
    private static final String KEYWORD_TEMPLATE = "(%s)(?=[A-Z])";
    private static final String PREFIX_TEMPLATE = "^%s(?=[A-Z]).*";
    private QueryMethod method;

    public QueryCreator(QueryMethod finderMethod) {
        Assert.isTrue((!finderMethod.isModifyingQuery() ? 1 : 0) != 0);
        this.method = finderMethod;
    }

    String constructQuery() {
        StringBuilder queryBuilder = new StringBuilder(QueryUtils.getQueryString("select x from %s x", this.method.getDomainClassName()));
        queryBuilder.append(" where ");
        PartSource source = new PartSource(this.method.getName());
        List<PartSource> orParts = source.getParts(OR);
        int parametersBound = 0;
        for (PartSource orPart : orParts) {
            List<PartSource> andParts = orPart.getParts(AND);
            StringBuilder andBuilder = new StringBuilder();
            for (PartSource andPart : andParts) {
                Parameters parameters = this.method.getParameters().getBindableParameters();
                Parameter parameter = parameters.hasParameterAt(parametersBound) ? parameters.getParameter(parametersBound) : null;
                try {
                    Part part = new Part(andPart.cleanedUp(), this.method, parameter);
                    andBuilder.append(part.getQueryPart()).append(" and ");
                    parametersBound += part.getNumberOfArguments();
                }
                catch (ParameterOutOfBoundsException e) {
                    throw QueryCreationException.create(this.method, e);
                }
            }
            andBuilder.delete(andBuilder.length() - 5, andBuilder.length());
            queryBuilder.append((CharSequence)andBuilder);
            queryBuilder.append(" or ");
        }
        if (!this.method.isCorrectNumberOfParameters(parametersBound)) {
            throw QueryCreationException.create(this.method, INVALID_PARAMETER_SIZE);
        }
        queryBuilder.delete(queryBuilder.length() - 4, queryBuilder.length());
        if (source.hasOrderByClause()) {
            queryBuilder.append(" ").append(source.getOrderBySource().getClause());
        }
        String query = queryBuilder.toString();
        LOG.debug("Created query '%s' from method %s", (Object)query, (Object)this.method.getName());
        return query;
    }

    static class OrderBySource {
        private final Order order;
        private final List<String> parts;

        public OrderBySource(String clause) {
            String[] partsArray = clause.split("(?<=[a-z])(?=[A-Z])");
            this.order = Order.fromJpaValue(partsArray[partsArray.length - 1]);
            this.parts = new ArrayList<String>();
            for (String part : partsArray) {
                this.parts.add(StringUtils.uncapitalize((String)part));
            }
            this.parts.remove(this.parts.size() - 1);
        }

        public String getClause() {
            StringBuilder builder = new StringBuilder("order by ");
            builder.append(StringUtils.collectionToDelimitedString(this.parts, (String)",", (String)"x.", (String)""));
            if (this.order != null) {
                builder.append(" ").append(this.order.getJpaValue());
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartSource {
        private static final String ORDER_BY = "OrderBy";
        private static final String[] PREFIXES = new String[]{"findBy", "find", "readBy", "read", "getBy", "get"};
        private final String cleanedUpString;
        private final OrderBySource orderBySource;

        public PartSource(String methodName) {
            String removedPrefixes = this.strip(methodName);
            String[] parts = this.split(removedPrefixes, ORDER_BY);
            if (parts.length > 2) {
                throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
            }
            this.cleanedUpString = parts[0];
            this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1]) : null;
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }

        public boolean hasOrderByClause() {
            return this.orderBySource != null;
        }

        public List<PartSource> getParts(String keyword) {
            ArrayList<PartSource> parts = new ArrayList<PartSource>();
            for (String part : this.split(this.cleanedUpString, keyword)) {
                parts.add(new PartSource(part));
            }
            return parts;
        }

        public String cleanedUp() {
            return this.cleanedUpString;
        }

        private String strip(String methodName) {
            for (String prefix : PREFIXES) {
                String regex = String.format(QueryCreator.PREFIX_TEMPLATE, prefix);
                if (!methodName.matches(regex)) continue;
                return methodName.substring(prefix.length());
            }
            return methodName;
        }

        private String[] split(String text, String keyword) {
            String regex = String.format(QueryCreator.KEYWORD_TEMPLATE, keyword);
            Pattern pattern = Pattern.compile(regex);
            return pattern.split(text);
        }
    }

    private static class Part {
        private final String part;
        private final Type type;
        private final Parameter parameter;
        private final QueryMethod method;

        public Part(String part, QueryMethod method, Parameter parameter) {
            this.part = part;
            this.type = Type.fromProperty(part, method);
            this.method = method;
            this.parameter = parameter;
        }

        public int getNumberOfArguments() {
            return this.type.getNumberOfArguments();
        }

        public String getQueryPart() {
            String property = this.type.extractProperty(this.part);
            if (!this.method.isValidField(property)) {
                throw QueryCreationException.invalidProperty(this.method, property);
            }
            return this.type.createQueryPart(StringUtils.uncapitalize((String)property), this.parameter);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            BETWEEN(null, new String[]{"Between"}){

                public int getNumberOfArguments() {
                    return 2;
                }

                public String createQueryPart(String property, Parameter parameter) {
                    String first = parameter.getPlaceholder();
                    String second = parameter.getNext().getPlaceholder();
                    return String.format("x.%s between %s and %s", property, first, second);
                }
            }
            ,
            IS_NOT_NULL(null, new String[]{"IsNotNull", "NotNull"}){

                public int getNumberOfArguments() {
                    return 0;
                }

                public String createQueryPart(String property, Parameter parameter) {
                    return String.format("x.%s is not null", property);
                }
            }
            ,
            IS_NULL(null, new String[]{"IsNull", "Null"}){

                public int getNumberOfArguments() {
                    return 0;
                }

                public String createQueryPart(String property, Parameter parameter) {
                    return String.format("x.%s is null", property);
                }
            }
            ,
            LESS_THAN("<", "LessThan"),
            GREATER_THAN(">", "GreaterThan"),
            NOT_LIKE("not like", "NotLike"),
            LIKE("like", "Like"),
            NEGATING_SIMPLE_PROPERTY("<>", "Not"),
            SIMPLE_PROPERTY("=", new String[0]);

            private static final List<Type> ALL;
            private List<String> keywords;
            private String operator;

            private Type(String operator, String ... keywords) {
                this.keywords = Arrays.asList(keywords);
                this.operator = operator;
            }

            public static Type fromProperty(String rawProperty, QueryMethod method) {
                for (Type type : ALL) {
                    if (!type.supports(rawProperty, method)) continue;
                    return type;
                }
                return SIMPLE_PROPERTY;
            }

            public String createQueryPart(String property, Parameter parameter) {
                return String.format("x.%s %s %s", property, this.operator, parameter.getPlaceholder());
            }

            protected boolean supports(String property, QueryMethod method) {
                if (this.keywords == null) {
                    return true;
                }
                if (method.isValidField(property)) {
                    return false;
                }
                for (String keyword : this.keywords) {
                    if (!property.endsWith(keyword)) continue;
                    return true;
                }
                return false;
            }

            public int getNumberOfArguments() {
                return 1;
            }

            public String extractProperty(String part) {
                for (String keyword : this.keywords) {
                    if (!part.endsWith(keyword)) continue;
                    return part.substring(0, part.indexOf(keyword));
                }
                return part;
            }

            static {
                ALL = Arrays.asList(IS_NOT_NULL, IS_NULL, BETWEEN, LESS_THAN, GREATER_THAN, NOT_LIKE, LIKE, NEGATING_SIMPLE_PROPERTY, SIMPLE_PROPERTY);
            }
        }
    }
}

