/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.springframework.util.Assert;
import org.synyx.hades.dao.query.AbstractHadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.domain.PageImpl;

abstract class QueryExecution {
    QueryExecution() {
    }

    public Object execute(AbstractHadesQuery query, ParameterBinder binder) {
        Assert.notNull((Object)query);
        Assert.notNull((Object)binder);
        try {
            return this.doExecute(query, binder);
        }
        catch (NoResultException e) {
            return null;
        }
    }

    protected abstract Object doExecute(AbstractHadesQuery var1, ParameterBinder var2);

    static class ModifyingExecution
    extends QueryExecution {
        private final EntityManager em;

        public ModifyingExecution(Method method, EntityManager em) {
            Class<?> type = method.getReturnType();
            boolean isVoid = Void.TYPE.equals(type) || Void.class.equals(type);
            boolean isInt = Integer.TYPE.equals(type) || Integer.class.equals(type);
            Assert.isTrue((isInt || isVoid ? 1 : 0) != 0, (String)"Modifying queries can only use void or int/Integer as return type!");
            this.em = em;
        }

        protected Object doExecute(AbstractHadesQuery query, ParameterBinder binder) {
            int result = binder.bind(query.createJpaQuery(binder)).executeUpdate();
            if (this.em != null) {
                this.em.clear();
            }
            return result;
        }
    }

    static class SingleEntityExecution
    extends QueryExecution {
        SingleEntityExecution() {
        }

        protected Object doExecute(AbstractHadesQuery query, ParameterBinder binder) {
            return binder.bind(query.createJpaQuery(binder)).getSingleResult();
        }
    }

    static class PagedExecution
    extends QueryExecution {
        PagedExecution() {
        }

        protected Object doExecute(AbstractHadesQuery query, ParameterBinder binder) {
            Query projection = binder.bind(query.createCountQuery());
            Long total = (Long)projection.getSingleResult();
            Query jpaQuery = binder.bindAndPrepare(query.createJpaQuery(binder));
            return new PageImpl(jpaQuery.getResultList(), binder.getPageable(), total);
        }
    }

    static class CollectionExecution
    extends QueryExecution {
        CollectionExecution() {
        }

        protected Object doExecute(AbstractHadesQuery query, ParameterBinder binder) {
            return binder.bindAndPrepare(query.createJpaQuery(binder)).getResultList();
        }
    }
}

