/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.util.Assert;
import org.synyx.hades.domain.Sort;
import org.synyx.hades.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    public static final String READ_ALL_QUERY = "select x from %s x";
    private static final String DEFAULT_ALIAS = "x";
    private static final String COUNT_REPLACEMENT = "select count($3$5) $4$5$6";
    private static final Pattern ALIAS_MATCH;
    private static final Pattern COUNT_MATCH;
    private static final String IDENTIFIER = "[\\p{L}._$]+";
    private static final String IDENTIFIER_GROUP;

    private QueryUtils() {
    }

    public static String getQueryString(String template, Class<?> clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException("Class must not be null!");
        }
        return QueryUtils.getQueryString(template, ClassUtils.getEntityName(clazz));
    }

    public static String getQueryString(String template, String clazzName) {
        Assert.hasText((String)clazzName, (String)"Classname must not be null or empty!");
        return String.format(template, clazzName);
    }

    public static String applySorting(String query, Sort sort) {
        return QueryUtils.applySorting(query, sort, DEFAULT_ALIAS);
    }

    public static String applySorting(String query, Sort sort, String alias) {
        if (null == sort) {
            return query;
        }
        Assert.hasText((String)alias);
        StringBuilder builder = new StringBuilder(query);
        builder.append(" order by");
        for (Sort.Property property : sort) {
            builder.append(String.format(" %s.", alias));
            builder.append(property.getName());
            builder.append(" ");
            builder.append(property.getOrder().getJpaValue());
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String detectAlias(String query) {
        Matcher matcher = ALIAS_MATCH.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static <T> Query applyAndBind(String queryString, Collection<T> entities, EntityManager entityManager) {
        Assert.notNull((Object)queryString);
        Assert.notNull(entities);
        Assert.notNull((Object)entityManager);
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = QueryUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        for (int i = 0; i < entities.size(); ++i) {
            builder.append(String.format(" %s = ?%d", alias, i + 1));
            if (i >= entities.size() - 1) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        for (int i = 0; i < entities.size(); ++i) {
            query.setParameter(i + 1, iterator.next());
        }
        return query;
    }

    public static String createCountQueryFor(String originalQuery) {
        Assert.hasText((String)originalQuery);
        Matcher matcher = COUNT_MATCH.matcher(originalQuery);
        return matcher.replaceFirst(COUNT_REPLACEMENT);
    }

    static {
        IDENTIFIER_GROUP = String.format("(%s)", IDENTIFIER);
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?:\\s)+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?:\\sas)*");
        builder.append("(?:\\s)+");
        builder.append("(\\w*)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("(select\\s+((distinct )?.+?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
        COUNT_MATCH = Pattern.compile(builder.toString(), 2);
    }
}

