/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain.auditing.support;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class AuditingBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    static final String BEAN_CONFIGURER_ASPECT_BEAN_NAME = "org.springframework.context.config.internalBeanConfigurerAspect";
    private static final String JPA_PACKAGE = "org.springframework.orm.jpa.";
    private static final List<String> CLASSES_TO_DEPEND = Arrays.asList("org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean", "org.springframework.orm.jpa.LocalEntityManagerFactoryBean");

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (!this.isSpringConfigured((BeanFactory)beanFactory)) {
            return;
        }
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            if (CLASSES_TO_DEPEND.contains(definition.getBeanClassName())) {
                definition.setDependsOn(StringUtils.addStringToArray((String[])definition.getDependsOn(), (String)BEAN_CONFIGURER_ASPECT_BEAN_NAME));
            }
            ++n2;
        }
    }

    private boolean isSpringConfigured(BeanFactory factory) {
        try {
            factory.getBean(BEAN_CONFIGURER_ASPECT_BEAN_NAME);
            return true;
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return false;
        }
    }
}

