/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.orm;

import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.support.PersistenceExceptionTranslationInterceptor;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.synyx.hades.dao.orm.DaoProxyPostProcessor;

class TransactionalDaoProxyPostProcessor
implements DaoProxyPostProcessor {
    private final TransactionInterceptor transactionInterceptor;
    private final PersistenceExceptionTranslationInterceptor petInterceptor;

    public TransactionalDaoProxyPostProcessor(ListableBeanFactory beanFactory, String transactionManagerName) {
        Assert.notNull((Object)beanFactory);
        Assert.notNull((Object)transactionManagerName);
        this.petInterceptor = new PersistenceExceptionTranslationInterceptor();
        this.petInterceptor.setBeanFactory((BeanFactory)beanFactory);
        this.petInterceptor.afterPropertiesSet();
        this.transactionInterceptor = new TransactionInterceptor(null, (TransactionAttributeSource)new AnnotationTransactionAttributeSource());
        this.transactionInterceptor.setTransactionManagerBeanName(transactionManagerName);
        this.transactionInterceptor.setBeanFactory((BeanFactory)beanFactory);
        this.transactionInterceptor.afterPropertiesSet();
    }

    public void postProcess(ProxyFactory factory) {
        factory.addAdvice((Advice)this.petInterceptor);
        factory.addAdvice((Advice)this.transactionInterceptor);
    }
}

