/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import javax.persistence.Query;
import org.springframework.util.Assert;
import org.synyx.hades.dao.query.Parameter;
import org.synyx.hades.dao.query.Parameters;
import org.synyx.hades.domain.Pageable;
import org.synyx.hades.domain.Sort;

class ParameterBinder {
    private final Parameters parameters;
    private final Object[] values;

    public ParameterBinder(Parameters parameters, Object ... values) {
        Assert.notNull((Object)parameters);
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = values;
    }

    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    public Query bind(Query query) {
        int methodParameterPosition = 0;
        for (Parameter parameter : this.parameters) {
            if (parameter.isBindable()) {
                Object value = this.values[methodParameterPosition];
                if (parameter.isNamedParameter()) {
                    query.setParameter(parameter.getParameterName(), value);
                } else {
                    query.setParameter(parameter.getParameterPosition(), value);
                }
            }
            ++methodParameterPosition;
        }
        return query;
    }

    public Query bindAndPrepare(Query query) {
        Query result = this.bind(query);
        if (!this.parameters.hasPageableParameter() || this.getPageable() == null) {
            return result;
        }
        result.setFirstResult(this.getPageable().getFirstItem());
        result.setMaxResults(this.getPageable().getPageSize());
        return result;
    }
}

