/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.dao.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synyx.hades.dao.query.AbstractHadesQuery;
import org.synyx.hades.dao.query.HadesQuery;
import org.synyx.hades.dao.query.ParameterBinder;
import org.synyx.hades.dao.query.QueryCreationException;
import org.synyx.hades.dao.query.QueryCreator;
import org.synyx.hades.dao.query.QueryMethod;
import org.synyx.hades.dao.query.QueryUtils;

final class SimpleHadesQuery
extends AbstractHadesQuery {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHadesQuery.class);
    private final String queryString;
    private final String countQuery;
    private final String alias;
    private final List<QueryHint> hints;

    SimpleHadesQuery(QueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        this.queryString = queryString;
        this.alias = QueryUtils.detectAlias(queryString);
        this.hints = method.getHints();
        this.countQuery = method.getCountQuery() == null ? QueryUtils.createCountQueryFor(queryString) : method.getCountQuery();
    }

    SimpleHadesQuery(QueryMethod method, EntityManager em) {
        this(method, em, new QueryCreator(method).constructQuery());
    }

    protected Query createQuery(EntityManager em, ParameterBinder binder) {
        String query = QueryUtils.applySorting(this.queryString, binder.getSort(), this.alias);
        return this.applyHints(em.createQuery(query));
    }

    protected Query createCountQuery(EntityManager em) {
        return this.applyHints(em.createQuery(this.countQuery));
    }

    private Query applyHints(Query query) {
        for (QueryHint hint : this.hints) {
            query.setHint(hint.name(), (Object)hint.value());
        }
        return query;
    }

    public static HadesQuery fromHadesAnnotation(QueryMethod queryMethod, EntityManager em) {
        LOG.debug("Looking up Hades query for method {}", (Object)queryMethod.getName());
        String query = queryMethod.getAnnotatedQuery();
        return query == null ? null : new SimpleHadesQuery(queryMethod, em, query);
    }

    public static HadesQuery construct(QueryMethod queryMethod, EntityManager em) {
        if (queryMethod.isModifyingQuery()) {
            throw QueryCreationException.create(queryMethod, "Cannot create query from method name for modifying query. Use @Query or @NamedQuery to declare the query to execute. Do not use CREATE as strategy to lookup queries!");
        }
        return new SimpleHadesQuery(queryMethod, em);
    }
}

