/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.domain.auditing.support;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;
import org.springframework.util.Assert;
import org.synyx.hades.domain.auditing.Auditable;
import org.synyx.hades.domain.auditing.AuditorAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class AuditingEntityListener<T>
implements InitializingBean,
ConfigurableObject {
    private static final Logger LOG;
    private AuditorAware<T> auditorAware;
    private boolean dateTimeForNow;
    private boolean modifyOnCreation;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("AuditingEntityListener.java", Class.forName("org.synyx.hades.domain.auditing.support.AuditingEntityListener"));
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 55);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.synyx.hades.domain.auditing.support.AuditingEntityListener", "", "", ""), 55);
        LOG = LoggerFactory.getLogger(AuditingEntityListener.class);
    }

    public AuditingEntityListener() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if ((this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && this != null && this.getClass().isAnnotationPresent(Configurable.class) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.dateTimeForNow = true;
        this.modifyOnCreation = true;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public void setAuditorAware(AuditorAware<T> auditorAware) {
        Assert.notNull(auditorAware);
        this.auditorAware = auditorAware;
    }

    public void setDateTimeForNow(boolean dateTimeForNow) {
        this.dateTimeForNow = dateTimeForNow;
    }

    public void setModifyOnCreation(boolean modifyOnCreation) {
        this.modifyOnCreation = modifyOnCreation;
    }

    @PrePersist
    @PreUpdate
    public void touch(Object target) {
        if (!(target instanceof Auditable)) {
            return;
        }
        Auditable auditable = (Auditable)target;
        T auditor = this.touchAuditor(auditable);
        DateTime now = this.dateTimeForNow ? this.touchDate(auditable) : null;
        String defaultedNow = now == null ? "not set" : now;
        String defaultedAuditor = auditor == null ? "unknown" : auditor;
        LOG.debug("Touched {} - Last modification at {} by {}", new Object[]{auditable, defaultedNow, defaultedAuditor});
    }

    private T touchAuditor(Auditable<T, ?> auditable) {
        if (this.auditorAware == null) {
            return null;
        }
        T auditor = this.auditorAware.getCurrentAuditor();
        if (auditable.isNew()) {
            auditable.setCreatedBy(auditor);
            if (!this.modifyOnCreation) {
                return auditor;
            }
        }
        auditable.setLastModifiedBy(auditor);
        return auditor;
    }

    private DateTime touchDate(Auditable<T, ?> auditable) {
        DateTime now = new DateTime();
        if (auditable.isNew()) {
            auditable.setCreatedDate(now);
            if (!this.modifyOnCreation) {
                return now;
            }
        }
        auditable.setLastModifiedDate(now);
        return now;
    }

    public void afterPropertiesSet() {
        if (this.auditorAware == null) {
            LOG.debug("No AuditorAware set! Auditing will not be applied!");
        }
    }
}

