/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hades.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.StringUtils;
import org.synyx.hades.dao.GenericDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassUtils {
    private static final TypeVariable<Class<GenericDao>>[] PARAMETERS = GenericDao.class.getTypeParameters();
    private static final String DOMAIN_TYPE_NAME = PARAMETERS[0].getName();
    private static final String ID_TYPE_NAME = PARAMETERS[1].getName();

    private ClassUtils() {
    }

    public static Class<?> getDomainClass(Class<?> clazz) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(clazz, GenericDao.class);
        return arguments == null ? null : arguments[0];
    }

    public static Class<? extends Serializable> getIdClass(Class<?> clazz) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(clazz, GenericDao.class);
        return arguments == null ? null : arguments[1];
    }

    public static Class<?> getReturnedDomainClass(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return method.getReturnType();
    }

    public static boolean isGenericDaoInterface(Class<?> interfaze) {
        return GenericDao.class.equals(interfaze);
    }

    public static boolean isHadesDaoInterface(String interfaceName) {
        return GenericDao.class.getName().equals(interfaceName);
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        try {
            Class<?> emType = Class.forName(type);
            emType.cast(em);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static int getNumberOfOccurences(Method method, Class<?> type) {
        int result = 0;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (!type.equals(clazz)) continue;
            ++result;
        }
        return result;
    }

    public static void assertReturnType(Method method, Class<?> ... types) {
        if (!Arrays.asList(types).contains(method.getReturnType())) {
            throw new IllegalStateException("Method has to have one of the following return types! " + Arrays.toString(types));
        }
    }

    public static boolean isOfType(Object object, Collection<Class<?>> types) {
        if (null == object) {
            return false;
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return Arrays.asList(method.getParameterTypes()).contains(type);
    }

    public static String getEntityName(Class<?> domainClass) {
        Entity entity = domainClass.getAnnotation(Entity.class);
        boolean hasName = null != entity && StringUtils.hasText((String)entity.name());
        return hasName ? entity.name() : domainClass.getSimpleName();
    }

    public static void unwrapReflectionException(Exception ex) throws Throwable {
        if (ex instanceof InvocationTargetException) {
            throw ((InvocationTargetException)ex).getTargetException();
        }
        throw ex;
    }

    public static Method getBaseClassMethodFor(Method method, Class<?> baseClass, Class<?> daoInterface) {
        for (Method daoClassMethod : baseClass.getMethods()) {
            if (!method.getName().equals(daoClassMethod.getName()) || method.getParameterTypes().length != daoClassMethod.getParameterTypes().length || !ClassUtils.parametersMatch(method, daoClassMethod, daoInterface)) continue;
            return daoClassMethod;
        }
        return method;
    }

    private static boolean parametersMatch(Method method, Method baseClassMethod, Class<?> daoInterface) {
        Type[] genericTypes = baseClassMethod.getGenericParameterTypes();
        Class<?>[] types = baseClassMethod.getParameterTypes();
        Class<?>[] methodParameters = method.getParameterTypes();
        for (int i = 0; i < genericTypes.length; ++i) {
            String name;
            Type type = genericTypes[i];
            if (!(type instanceof TypeVariable ? !ClassUtils.matchesGenericType(name = ((TypeVariable)type).getName(), methodParameters[i], daoInterface) : !types[i].equals(methodParameters[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesGenericType(String name, Class<?> parameterType, Class<?> daoInterface) {
        Class<?> entityType = ClassUtils.getDomainClass(daoInterface);
        Class<? extends Serializable> idClass = ClassUtils.getIdClass(daoInterface);
        if (ID_TYPE_NAME.equals(name) && parameterType.equals(idClass)) {
            return true;
        }
        return DOMAIN_TYPE_NAME.equals(name) && parameterType.equals(entityType);
    }
}

