/*
 * Decompiled with CFR 0.152.
 */
package org.synyx.hera.si;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.synyx.hera.core.Plugin;
import org.synyx.hera.core.PluginRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRegistryAwareMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static final Log LOG = LogFactory.getLog(PluginRegistryAwareMessageHandler.class);
    private final PluginRegistry<? extends Plugin<?>, Object> registry;
    private final Class<? extends Plugin<?>> pluginType;
    private final Class<?> delimiterType;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private Expression delimiterExpression;
    private Expression invocationArgumentsExpression;
    private String serviceMethodName;
    private PluginLookupMethod pluginLookupMethod = PluginLookupMethod.getDefault();

    public PluginRegistryAwareMessageHandler(PluginRegistry<? extends Plugin<?>, ?> registry, Class<? extends Plugin<?>> pluginType, String serviceMethodName) {
        Assert.notNull(registry);
        Assert.notNull(pluginType);
        Assert.hasText((String)serviceMethodName);
        this.registry = registry;
        this.serviceMethodName = serviceMethodName;
        this.pluginType = pluginType;
        this.delimiterType = GenericTypeResolver.resolveTypeArgument(pluginType, Plugin.class);
        this.verify();
    }

    private final void verify() {
        boolean methodFound = false;
        for (Method candidate : this.pluginType.getMethods()) {
            if (!candidate.getName().equals(this.serviceMethodName)) continue;
            methodFound = true;
            break;
        }
        if (!methodFound) {
            throw new IllegalArgumentException(String.format("Not method %s found for type %s!", this.serviceMethodName, this.pluginType));
        }
    }

    public void setDelimiterExpression(String expression) {
        Assert.hasText((String)expression);
        this.delimiterExpression = this.parser.parseExpression(expression);
    }

    public void setInvocationArgumentsExpression(String expression) {
        Assert.hasText((String)expression);
        this.invocationArgumentsExpression = this.parser.parseExpression(expression);
    }

    public void setPluginLookupMethod(PluginLookupMethod pluginLookupMethod) {
        this.pluginLookupMethod = pluginLookupMethod == null ? PluginLookupMethod.getDefault() : pluginLookupMethod;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object delimiter = this.getDelimiter(requestMessage);
        switch (this.pluginLookupMethod) {
            case ALL: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Looking up plugins for delimiter %s", delimiter));
                }
                return this.invokePlugins(this.registry.getPluginsFor(delimiter), requestMessage);
            }
            case ONE: {
                List<Object> results;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Looking up plugin for delimiter %s", delimiter));
                }
                return (results = this.invokePlugins(Arrays.asList(this.registry.getPluginFor(delimiter)), requestMessage)).isEmpty() ? null : results.get(0);
            }
        }
        throw new IllegalStateException(String.format("Unsupported plugin lookup method %s!", new Object[]{this.pluginLookupMethod}));
    }

    private List<Object> invokePlugins(Collection<? extends Plugin<?>> plugins, Message<?> message) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Invoking plugin(s) %s with message %s", StringUtils.collectionToCommaDelimitedString(plugins), message));
        }
        for (Plugin<?> plugin : plugins) {
            Object[] invocationArguments = this.getInvocationArguments(message);
            Object[] types = this.getTypes(invocationArguments);
            Method businessMethod = ReflectionUtils.findMethod(this.pluginType, (String)this.serviceMethodName, (Class[])types);
            if (businessMethod == null) {
                throw new MessageHandlingException(message, String.format("Did not find a method %s on %s taking the following parameters %s", this.serviceMethodName, this.pluginType.getName(), Arrays.toString(types)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Invoke plugin method %s using arguments %s", businessMethod, Arrays.toString(invocationArguments)));
            }
            Object result = ReflectionUtils.invokeMethod((Method)businessMethod, plugin, (Object[])invocationArguments);
            if (businessMethod.getReturnType().equals(Void.TYPE)) continue;
            results.add(result);
        }
        return results;
    }

    private Object getDelimiter(Message<?> message) {
        Object delimiter = message;
        if (this.delimiterExpression != null) {
            StandardEvaluationContext context = new StandardEvaluationContext(message);
            delimiter = this.delimiterExpression.getValue((EvaluationContext)context);
        }
        Assert.isInstanceOf(this.delimiterType, delimiter, (String)String.format("Delimiter expression did not return a suitable delimiter! Make sure the expression evaluates to a suitable type! Got %s but need %s", delimiter.getClass(), this.delimiterType));
        return delimiter;
    }

    private Object[] getInvocationArguments(Message<?> message) {
        Object[] objectArray;
        if (this.invocationArgumentsExpression == null) {
            return new Object[]{message};
        }
        StandardEvaluationContext context = new StandardEvaluationContext(message);
        Object result = this.delimiterExpression.getValue((EvaluationContext)context);
        if (ObjectUtils.isArray((Object)result)) {
            objectArray = ObjectUtils.toObjectArray((Object)result);
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = result;
        }
        return objectArray;
    }

    private Class<?>[] getTypes(Object[] source) {
        Class[] result = new Class[source.length];
        for (int i = 0; i < source.length; ++i) {
            Object sourceElement = source[i];
            result[i] = sourceElement == null ? null : sourceElement.getClass();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PluginLookupMethod {
        ONE,
        ALL;


        static PluginLookupMethod getDefault() {
            return ONE;
        }
    }
}

