/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import java.util.ArrayList;
import java.util.List;
import org.tahomarobotics.robot.motion.MotionProfile;
import org.tahomarobotics.robot.motion.MotionProfiles;
import org.tahomarobotics.robot.motion.TrapezoidalMotionProfile;
import org.tahomarobotics.robot.path.PathSection;

public class Motion2DProfileFactory {
    public static MotionProfiles createTrapezoidMotionProfile(List<PathSection> sections, double maxAccel) {
        ArrayList<MotionProfile> motionProfiles = new ArrayList<MotionProfile>();
        Motion2DProfileFactory.createMotionProfiles(sections, Profile.Trapezoid, maxAccel, 0.0, motionProfiles);
        return new MotionProfiles(motionProfiles);
    }

    public static MotionProfiles createTrapezoidMotionProfile(List<PathSection> sections, double maxAccel, double maxRotationalAccel) {
        ArrayList<MotionProfile> fwdMotionProfiles = new ArrayList<MotionProfile>();
        Motion2DProfileFactory.createMotionProfiles(sections, Profile.Trapezoid, maxAccel, 0.0, fwdMotionProfiles);
        ArrayList<MotionProfile> rotMotionProfiles = new ArrayList<MotionProfile>();
        Motion2DProfileFactory.createRotationalMotionProfiles(sections, Profile.Trapezoid, fwdMotionProfiles, maxRotationalAccel, 0.0, rotMotionProfiles);
        return new MotionProfiles(fwdMotionProfiles, rotMotionProfiles);
    }

    private static void createMotionProfiles(List<PathSection> sections, Profile profile, double maxAccel, double maxJerk, List<MotionProfile> motionProfiles) {
        double startTime = 0.0;
        double startVelocity = 0.0;
        double startPosition = 0.0;
        for (int i = 0; i < sections.size(); ++i) {
            PathSection section = sections.get(i);
            double endPosition = startPosition + section.length;
            double maxVelocity = section.maxVelocity;
            double nextVelocity = i + 1 < sections.size() ? sections.get((int)(i + 1)).maxVelocity : 0.0;
            double endVelocity = Math.min(maxVelocity, nextVelocity);
            MotionProfile motionProfile = Motion2DProfileFactory.createMotionProfile(profile, startTime, startPosition, endPosition, startVelocity, endVelocity, maxVelocity, maxAccel, maxJerk);
            motionProfiles.add(motionProfile);
            startVelocity = endVelocity;
            startPosition = endPosition;
            startTime = motionProfile.getEndTime();
        }
    }

    private static void createRotationalMotionProfiles(List<PathSection> sections, Profile profile, List<MotionProfile> fwdProfiles, double maxRotAccel, double maxRotJerk, List<MotionProfile> rotProfiles) {
        double startTime = 0.0;
        for (int i = 0; i < sections.size(); ++i) {
            PathSection section = sections.get(i);
            MotionProfile fwdMotionProfile = fwdProfiles.get(i);
            double duration = fwdMotionProfile.getEndTime() - startTime;
            double minAcceleration = 4.0 * Math.abs(section.angle) / duration / duration;
            if (maxRotAccel < minAcceleration) {
                System.err.format("Rotational Acceleration too low %f < %f\n", maxRotAccel, minAcceleration);
                maxRotAccel = minAcceleration;
            }
            section.maxRotationalVelocity = maxRotAccel / 2.0 * (duration - Math.sqrt(duration * duration - 4.0 * Math.abs(section.angle) / maxRotAccel));
            startTime = fwdMotionProfile.getEndTime();
        }
        startTime = 0.0;
        double startRotationalVelocity = 0.0;
        double startRotationalPosition = sections.get((int)0).startPose.heading;
        for (int i = 0; i < sections.size(); ++i) {
            PathSection section = sections.get(i);
            double maxRotationalVelocity = section.maxRotationalVelocity;
            double direction = Math.signum(section.angle);
            double endRotationalPosition = startRotationalPosition + section.angle;
            double nextRotationalVelocity = i + 1 < sections.size() ? sections.get((int)(i + 1)).maxRotationalVelocity : 0.0;
            double endRotationalVelocity = direction * Math.min(Math.abs(maxRotationalVelocity), Math.abs(nextRotationalVelocity));
            MotionProfile rotMotionProfile = Motion2DProfileFactory.createMotionProfile(profile, startTime, startRotationalPosition, endRotationalPosition, startRotationalVelocity, endRotationalVelocity, maxRotationalVelocity, maxRotAccel, maxRotJerk);
            rotProfiles.add(rotMotionProfile);
            startRotationalVelocity = endRotationalVelocity;
            startRotationalPosition = endRotationalPosition;
            startTime = fwdProfiles.get(i).getEndTime();
        }
    }

    private static MotionProfile createMotionProfile(Profile profile, double startTime, double startPosition, double endPosition, double startVelocity, double endVelocity, double maxVelocity, double maxAccel, double maxJerk) {
        try {
            switch (profile) {
                case Trapezoid: {
                    return new TrapezoidalMotionProfile(startTime, startPosition, endPosition, startVelocity, endVelocity, maxVelocity, maxAccel);
                }
            }
        }
        catch (MotionProfile.MotionProfileException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static enum Profile {
        Trapezoid,
        SCurve;

    }
}

