/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import org.tahomarobotics.robot.motion.MotionState;

public class MotionController {
    public final double kP;
    public final double kV;
    public final double kI;
    public final double kffV;
    public final double kffA;
    public final double positionTolerance;
    private double totalError;
    private double prevTime;
    private volatile boolean onTarget = true;
    private double positionError;
    private double velocityError;

    public MotionController(double kP, double kV, double kI, double kffV, double kffA, double positionTolerance) {
        this.kP = kP;
        this.kV = kV;
        this.kI = kI;
        this.kffV = kffV;
        this.kffA = kffA;
        this.positionTolerance = positionTolerance;
    }

    public void reset() {
        this.prevTime = Double.NaN;
        this.totalError = 0.0;
        this.onTarget = false;
    }

    public double update(double time, MotionState currentState, MotionState setpoint) {
        this.positionError = setpoint.position - currentState.position;
        this.velocityError = setpoint.velocity - currentState.velocity;
        this.totalError = Double.isNaN(this.prevTime) ? 0.0 : this.totalError + this.positionError * (time - this.prevTime);
        this.prevTime = time;
        double output = this.kffV * setpoint.velocity + this.kffA * setpoint.acceleration + this.kP * this.positionError + this.kV * this.velocityError + this.kI * this.totalError;
        this.onTarget = Math.abs(this.positionError) <= this.positionTolerance;
        return output;
    }

    public double getPositionError() {
        return this.positionError;
    }

    public boolean onTarget() {
        return this.onTarget;
    }

    public String toString() {
        return String.format("%7.2f,%7.2f,%7.2f", this.positionError, this.velocityError, this.totalError);
    }
}

