/*
 * Decompiled with CFR 0.152.
 */
package org.tahomarobotics.robot.motion;

import org.tahomarobotics.robot.motion.MotionState;

public abstract class MotionProfile {
    private final MotionState[] phases;
    protected final double startTime;
    protected final double startPosition;
    protected final double endPosition;
    protected final double startVelocity;
    protected final double endVelocity;
    protected final double maxVelocity;
    protected final double maxAcceleration;

    MotionProfile(double startTime, double startPosition, double endPosition, double startVelocity, double endVelocity, double maxVelocity, double maxAcceleration) throws MotionProfileException {
        this.startTime = startTime;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.startVelocity = startVelocity;
        this.endVelocity = endVelocity;
        this.maxVelocity = maxVelocity;
        this.maxAcceleration = maxAcceleration;
        this.phases = this.generatePhases();
    }

    protected abstract MotionState[] generatePhases() throws MotionProfileException;

    protected MotionState getPhaseSetpoint(double dt, MotionState initial, MotionState setpoint) {
        if (setpoint == null) {
            setpoint = new MotionState();
        }
        double jt = initial.jerk * dt;
        double jt2 = jt * dt / 2.0;
        double jt3 = jt2 * dt / 3.0;
        double at = initial.acceleration * dt;
        double at2 = at * dt / 2.0;
        double vt = initial.velocity * dt;
        setpoint.time = initial.time + dt;
        setpoint.jerk = initial.jerk;
        setpoint.acceleration = initial.acceleration + jt;
        setpoint.velocity = initial.velocity + at + jt2;
        setpoint.position = initial.position + vt + at2 + jt3;
        return setpoint;
    }

    public boolean getSetpoint(double time, MotionState setpoint) {
        for (int i = 1; i < this.phases.length; ++i) {
            if (!(time < this.phases[i].time)) continue;
            MotionState initial = this.phases[i - 1];
            this.getPhaseSetpoint(time - initial.time, initial, setpoint);
            return true;
        }
        setpoint.copy(this.phases[this.phases.length - 1]);
        return false;
    }

    public double getEndTime() {
        return this.phases[this.phases.length - 1].time;
    }

    public double getEndPosition() {
        return this.phases[this.phases.length - 1].position;
    }

    public MotionState getLastMotionState() {
        return this.phases[this.phases.length - 1];
    }

    public String toString() {
        return String.format("startTime %f, startPosition %f, endPosition %f, startVelocity %f, endVelocity %f, maxVelocity %f, maxAcceleration %f", this.startTime, this.startPosition, this.endPosition, this.startVelocity, this.endVelocity, this.maxVelocity, this.maxAcceleration);
    }

    public class MotionProfileException
    extends Exception {
        public MotionProfileException(String message) {
            super(message);
        }
    }
}

